/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ActorSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse;

public class ListActorsIterable
implements SdkIterable<ListActorsResponse> {
    private final BedrockAgentCoreClient client;
    private final ListActorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListActorsIterable(BedrockAgentCoreClient client, ListActorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListActorsResponseFetcher();
    }

    public Iterator<ListActorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ActorSummary> actorSummaries() {
        Function<ListActorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actorSummaries() != null) {
                return response.actorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListActorsResponseFetcher
    implements SyncPageFetcher<ListActorsResponse> {
        private ListActorsResponseFetcher() {
        }

        public boolean hasNextPage(ListActorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListActorsResponse nextPage(ListActorsResponse previousPage) {
            if (previousPage == null) {
                return ListActorsIterable.this.client.listActors(ListActorsIterable.this.firstRequest);
            }
            return ListActorsIterable.this.client.listActors((ListActorsRequest)((Object)ListActorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

