/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateBrowserStreamResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<UpdateBrowserStreamResponse.Builder, UpdateBrowserStreamResponse> {
    private static final SdkField<String> BROWSER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("browserIdentifier").getter(getter(UpdateBrowserStreamResponse::browserIdentifier))
            .setter(setter(Builder::browserIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("browserIdentifier").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(UpdateBrowserStreamResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<BrowserSessionStream> STREAMS_FIELD = SdkField
            .<BrowserSessionStream> builder(MarshallingType.SDK_POJO).memberName("streams")
            .getter(getter(UpdateBrowserStreamResponse::streams)).setter(setter(Builder::streams))
            .constructor(BrowserSessionStream::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("streams").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(UpdateBrowserStreamResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROWSER_IDENTIFIER_FIELD,
            SESSION_ID_FIELD, STREAMS_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String browserIdentifier;

    private final String sessionId;

    private final BrowserSessionStream streams;

    private final Instant updatedAt;

    private UpdateBrowserStreamResponse(BuilderImpl builder) {
        super(builder);
        this.browserIdentifier = builder.browserIdentifier;
        this.sessionId = builder.sessionId;
        this.streams = builder.streams;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The identifier of the browser.
     * </p>
     * 
     * @return The identifier of the browser.
     */
    public final String browserIdentifier() {
        return browserIdentifier;
    }

    /**
     * <p>
     * The identifier of the browser session.
     * </p>
     * 
     * @return The identifier of the browser session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * Returns the value of the Streams property for this object.
     * 
     * @return The value of the Streams property for this object.
     */
    public final BrowserSessionStream streams() {
        return streams;
    }

    /**
     * <p>
     * The time at which the browser stream was updated.
     * </p>
     * 
     * @return The time at which the browser stream was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(browserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(streams());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateBrowserStreamResponse)) {
            return false;
        }
        UpdateBrowserStreamResponse other = (UpdateBrowserStreamResponse) obj;
        return Objects.equals(browserIdentifier(), other.browserIdentifier()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(streams(), other.streams()) && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateBrowserStreamResponse").add("BrowserIdentifier", browserIdentifier())
                .add("SessionId", sessionId()).add("Streams", streams()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "browserIdentifier":
            return Optional.ofNullable(clazz.cast(browserIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "streams":
            return Optional.ofNullable(clazz.cast(streams()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("browserIdentifier", BROWSER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("streams", STREAMS_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateBrowserStreamResponse, T> g) {
        return obj -> g.apply((UpdateBrowserStreamResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateBrowserStreamResponse> {
        /**
         * <p>
         * The identifier of the browser.
         * </p>
         * 
         * @param browserIdentifier
         *        The identifier of the browser.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder browserIdentifier(String browserIdentifier);

        /**
         * <p>
         * The identifier of the browser session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the browser session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * Sets the value of the Streams property for this object.
         *
         * @param streams
         *        The new value for the Streams property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streams(BrowserSessionStream streams);

        /**
         * Sets the value of the Streams property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BrowserSessionStream.Builder} avoiding
         * the need to create one manually via {@link BrowserSessionStream#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BrowserSessionStream.Builder#build()} is called immediately and
         * its result is passed to {@link #streams(BrowserSessionStream)}.
         * 
         * @param streams
         *        a consumer that will call methods on {@link BrowserSessionStream.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #streams(BrowserSessionStream)
         */
        default Builder streams(Consumer<BrowserSessionStream.Builder> streams) {
            return streams(BrowserSessionStream.builder().applyMutation(streams).build());
        }

        /**
         * <p>
         * The time at which the browser stream was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the browser stream was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String browserIdentifier;

        private String sessionId;

        private BrowserSessionStream streams;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateBrowserStreamResponse model) {
            super(model);
            browserIdentifier(model.browserIdentifier);
            sessionId(model.sessionId);
            streams(model.streams);
            updatedAt(model.updatedAt);
        }

        public final String getBrowserIdentifier() {
            return browserIdentifier;
        }

        public final void setBrowserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
        }

        @Override
        public final Builder browserIdentifier(String browserIdentifier) {
            this.browserIdentifier = browserIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final BrowserSessionStream.Builder getStreams() {
            return streams != null ? streams.toBuilder() : null;
        }

        public final void setStreams(BrowserSessionStream.BuilderImpl streams) {
            this.streams = streams != null ? streams.build() : null;
        }

        @Override
        public final Builder streams(BrowserSessionStream streams) {
            this.streams = streams;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public UpdateBrowserStreamResponse build() {
            return new UpdateBrowserStreamResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
