/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeCodeInterpreterRequest extends BedrockAgentCoreRequest implements
        ToCopyableBuilder<InvokeCodeInterpreterRequest.Builder, InvokeCodeInterpreterRequest> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterIdentifier").getter(getter(InvokeCodeInterpreterRequest::codeInterpreterIdentifier))
            .setter(setter(Builder::codeInterpreterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("codeInterpreterIdentifier").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("sessionId")
            .getter(getter(InvokeCodeInterpreterRequest::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amzn-code-interpreter-session-id")
                    .build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(InvokeCodeInterpreterRequest::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<ToolArguments> ARGUMENTS_FIELD = SdkField.<ToolArguments> builder(MarshallingType.SDK_POJO)
            .memberName("arguments").getter(getter(InvokeCodeInterpreterRequest::arguments)).setter(setter(Builder::arguments))
            .constructor(ToolArguments::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arguments").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, NAME_FIELD, ARGUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterIdentifier;

    private final String sessionId;

    private final String name;

    private final ToolArguments arguments;

    private InvokeCodeInterpreterRequest(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.arguments = builder.arguments;
    }

    /**
     * <p>
     * The unique identifier of the code interpreter associated with the session. This must match the identifier used
     * when creating the session with <code>StartCodeInterpreterSession</code>.
     * </p>
     * 
     * @return The unique identifier of the code interpreter associated with the session. This must match the identifier
     *         used when creating the session with <code>StartCodeInterpreterSession</code>.
     */
    public final String codeInterpreterIdentifier() {
        return codeInterpreterIdentifier;
    }

    /**
     * <p>
     * The unique identifier of the code interpreter session to use. This must be an active session created with
     * <code>StartCodeInterpreterSession</code>. If the session has expired or been stopped, the request will fail.
     * </p>
     * 
     * @return The unique identifier of the code interpreter session to use. This must be an active session created with
     *         <code>StartCodeInterpreterSession</code>. If the session has expired or been stopped, the request will
     *         fail.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the code interpreter to invoke.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the code interpreter to invoke.
     * @see ToolName
     */
    public final ToolName name() {
        return ToolName.fromValue(name);
    }

    /**
     * <p>
     * The name of the code interpreter to invoke.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link ToolName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the code interpreter to invoke.
     * @see ToolName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The arguments for the code interpreter. This includes the code to execute and any additional parameters such as
     * the programming language, whether to clear the execution context, and other execution options. The structure of
     * this parameter depends on the specific code interpreter being used.
     * </p>
     * 
     * @return The arguments for the code interpreter. This includes the code to execute and any additional parameters
     *         such as the programming language, whether to clear the execution context, and other execution options.
     *         The structure of this parameter depends on the specific code interpreter being used.
     */
    public final ToolArguments arguments() {
        return arguments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(arguments());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeCodeInterpreterRequest)) {
            return false;
        }
        InvokeCodeInterpreterRequest other = (InvokeCodeInterpreterRequest) obj;
        return Objects.equals(codeInterpreterIdentifier(), other.codeInterpreterIdentifier())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(arguments(), other.arguments());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeCodeInterpreterRequest").add("CodeInterpreterIdentifier", codeInterpreterIdentifier())
                .add("SessionId", sessionId()).add("Name", nameAsString()).add("Arguments", arguments()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterIdentifier":
            return Optional.ofNullable(clazz.cast(codeInterpreterIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "arguments":
            return Optional.ofNullable(clazz.cast(arguments()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("x-amzn-code-interpreter-session-id", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("arguments", ARGUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeCodeInterpreterRequest, T> g) {
        return obj -> g.apply((InvokeCodeInterpreterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, InvokeCodeInterpreterRequest> {
        /**
         * <p>
         * The unique identifier of the code interpreter associated with the session. This must match the identifier
         * used when creating the session with <code>StartCodeInterpreterSession</code>.
         * </p>
         * 
         * @param codeInterpreterIdentifier
         *        The unique identifier of the code interpreter associated with the session. This must match the
         *        identifier used when creating the session with <code>StartCodeInterpreterSession</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterIdentifier(String codeInterpreterIdentifier);

        /**
         * <p>
         * The unique identifier of the code interpreter session to use. This must be an active session created with
         * <code>StartCodeInterpreterSession</code>. If the session has expired or been stopped, the request will fail.
         * </p>
         * 
         * @param sessionId
         *        The unique identifier of the code interpreter session to use. This must be an active session created
         *        with <code>StartCodeInterpreterSession</code>. If the session has expired or been stopped, the request
         *        will fail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the code interpreter to invoke.
         * </p>
         * 
         * @param name
         *        The name of the code interpreter to invoke.
         * @see ToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the code interpreter to invoke.
         * </p>
         * 
         * @param name
         *        The name of the code interpreter to invoke.
         * @see ToolName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ToolName
         */
        Builder name(ToolName name);

        /**
         * <p>
         * The arguments for the code interpreter. This includes the code to execute and any additional parameters such
         * as the programming language, whether to clear the execution context, and other execution options. The
         * structure of this parameter depends on the specific code interpreter being used.
         * </p>
         * 
         * @param arguments
         *        The arguments for the code interpreter. This includes the code to execute and any additional
         *        parameters such as the programming language, whether to clear the execution context, and other
         *        execution options. The structure of this parameter depends on the specific code interpreter being
         *        used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arguments(ToolArguments arguments);

        /**
         * <p>
         * The arguments for the code interpreter. This includes the code to execute and any additional parameters such
         * as the programming language, whether to clear the execution context, and other execution options. The
         * structure of this parameter depends on the specific code interpreter being used.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolArguments.Builder} avoiding the need
         * to create one manually via {@link ToolArguments#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolArguments.Builder#build()} is called immediately and its
         * result is passed to {@link #arguments(ToolArguments)}.
         * 
         * @param arguments
         *        a consumer that will call methods on {@link ToolArguments.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arguments(ToolArguments)
         */
        default Builder arguments(Consumer<ToolArguments.Builder> arguments) {
            return arguments(ToolArguments.builder().applyMutation(arguments).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentCoreRequest.BuilderImpl implements Builder {
        private String codeInterpreterIdentifier;

        private String sessionId;

        private String name;

        private ToolArguments arguments;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeCodeInterpreterRequest model) {
            super(model);
            codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            sessionId(model.sessionId);
            name(model.name);
            arguments(model.arguments);
        }

        public final String getCodeInterpreterIdentifier() {
            return codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(ToolName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final ToolArguments.Builder getArguments() {
            return arguments != null ? arguments.toBuilder() : null;
        }

        public final void setArguments(ToolArguments.BuilderImpl arguments) {
            this.arguments = arguments != null ? arguments.build() : null;
        }

        @Override
        public final Builder arguments(ToolArguments arguments) {
            this.arguments = arguments;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeCodeInterpreterRequest build() {
            return new InvokeCodeInterpreterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
