/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentcore.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCodeInterpreterSessionResponse extends BedrockAgentCoreResponse implements
        ToCopyableBuilder<GetCodeInterpreterSessionResponse.Builder, GetCodeInterpreterSessionResponse> {
    private static final SdkField<String> CODE_INTERPRETER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("codeInterpreterIdentifier").getter(getter(GetCodeInterpreterSessionResponse::codeInterpreterIdentifier))
            .setter(setter(Builder::codeInterpreterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterIdentifier").build())
            .build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetCodeInterpreterSessionResponse::sessionId))
            .setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetCodeInterpreterSessionResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(GetCodeInterpreterSessionResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionTimeoutSeconds").getter(getter(GetCodeInterpreterSessionResponse::sessionTimeoutSeconds))
            .setter(setter(Builder::sessionTimeoutSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeoutSeconds").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetCodeInterpreterSessionResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CODE_INTERPRETER_IDENTIFIER_FIELD, SESSION_ID_FIELD, NAME_FIELD, CREATED_AT_FIELD, SESSION_TIMEOUT_SECONDS_FIELD,
            STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String codeInterpreterIdentifier;

    private final String sessionId;

    private final String name;

    private final Instant createdAt;

    private final Integer sessionTimeoutSeconds;

    private final String status;

    private GetCodeInterpreterSessionResponse(BuilderImpl builder) {
        super(builder);
        this.codeInterpreterIdentifier = builder.codeInterpreterIdentifier;
        this.sessionId = builder.sessionId;
        this.name = builder.name;
        this.createdAt = builder.createdAt;
        this.sessionTimeoutSeconds = builder.sessionTimeoutSeconds;
        this.status = builder.status;
    }

    /**
     * <p>
     * The identifier of the code interpreter.
     * </p>
     * 
     * @return The identifier of the code interpreter.
     */
    public final String codeInterpreterIdentifier() {
        return codeInterpreterIdentifier;
    }

    /**
     * <p>
     * The identifier of the code interpreter session.
     * </p>
     * 
     * @return The identifier of the code interpreter session.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The name of the code interpreter session.
     * </p>
     * 
     * @return The name of the code interpreter session.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The time at which the code interpreter session was created.
     * </p>
     * 
     * @return The time at which the code interpreter session was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The timeout period for the code interpreter session in seconds.
     * </p>
     * 
     * @return The timeout period for the code interpreter session in seconds.
     */
    public final Integer sessionTimeoutSeconds() {
        return sessionTimeoutSeconds;
    }

    /**
     * <p>
     * The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and
     *         STOPPED.
     * @see CodeInterpreterSessionStatus
     */
    public final CodeInterpreterSessionStatus status() {
        return CodeInterpreterSessionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and STOPPED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CodeInterpreterSessionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and
     *         STOPPED.
     * @see CodeInterpreterSessionStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(codeInterpreterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCodeInterpreterSessionResponse)) {
            return false;
        }
        GetCodeInterpreterSessionResponse other = (GetCodeInterpreterSessionResponse) obj;
        return Objects.equals(codeInterpreterIdentifier(), other.codeInterpreterIdentifier())
                && Objects.equals(sessionId(), other.sessionId()) && Objects.equals(name(), other.name())
                && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(sessionTimeoutSeconds(), other.sessionTimeoutSeconds())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCodeInterpreterSessionResponse")
                .add("CodeInterpreterIdentifier", codeInterpreterIdentifier()).add("SessionId", sessionId()).add("Name", name())
                .add("CreatedAt", createdAt()).add("SessionTimeoutSeconds", sessionTimeoutSeconds())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "codeInterpreterIdentifier":
            return Optional.ofNullable(clazz.cast(codeInterpreterIdentifier()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "sessionTimeoutSeconds":
            return Optional.ofNullable(clazz.cast(sessionTimeoutSeconds()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("codeInterpreterIdentifier", CODE_INTERPRETER_IDENTIFIER_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("sessionTimeoutSeconds", SESSION_TIMEOUT_SECONDS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCodeInterpreterSessionResponse, T> g) {
        return obj -> g.apply((GetCodeInterpreterSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentCoreResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCodeInterpreterSessionResponse> {
        /**
         * <p>
         * The identifier of the code interpreter.
         * </p>
         * 
         * @param codeInterpreterIdentifier
         *        The identifier of the code interpreter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder codeInterpreterIdentifier(String codeInterpreterIdentifier);

        /**
         * <p>
         * The identifier of the code interpreter session.
         * </p>
         * 
         * @param sessionId
         *        The identifier of the code interpreter session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The name of the code interpreter session.
         * </p>
         * 
         * @param name
         *        The name of the code interpreter session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The time at which the code interpreter session was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the code interpreter session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The timeout period for the code interpreter session in seconds.
         * </p>
         * 
         * @param sessionTimeoutSeconds
         *        The timeout period for the code interpreter session in seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds);

        /**
         * <p>
         * The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and
         *        STOPPED.
         * @see CodeInterpreterSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterSessionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and STOPPED.
         * </p>
         * 
         * @param status
         *        The current status of the code interpreter session. Possible values include ACTIVE, STOPPING, and
         *        STOPPED.
         * @see CodeInterpreterSessionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CodeInterpreterSessionStatus
         */
        Builder status(CodeInterpreterSessionStatus status);
    }

    static final class BuilderImpl extends BedrockAgentCoreResponse.BuilderImpl implements Builder {
        private String codeInterpreterIdentifier;

        private String sessionId;

        private String name;

        private Instant createdAt;

        private Integer sessionTimeoutSeconds;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCodeInterpreterSessionResponse model) {
            super(model);
            codeInterpreterIdentifier(model.codeInterpreterIdentifier);
            sessionId(model.sessionId);
            name(model.name);
            createdAt(model.createdAt);
            sessionTimeoutSeconds(model.sessionTimeoutSeconds);
            status(model.status);
        }

        public final String getCodeInterpreterIdentifier() {
            return codeInterpreterIdentifier;
        }

        public final void setCodeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
        }

        @Override
        public final Builder codeInterpreterIdentifier(String codeInterpreterIdentifier) {
            this.codeInterpreterIdentifier = codeInterpreterIdentifier;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Integer getSessionTimeoutSeconds() {
            return sessionTimeoutSeconds;
        }

        public final void setSessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
        }

        @Override
        public final Builder sessionTimeoutSeconds(Integer sessionTimeoutSeconds) {
            this.sessionTimeoutSeconds = sessionTimeoutSeconds;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CodeInterpreterSessionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetCodeInterpreterSessionResponse build() {
            return new GetCodeInterpreterSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
