/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.MemoryRecordSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.RetrieveMemoryRecordsResponse;

public class RetrieveMemoryRecordsIterable
implements SdkIterable<RetrieveMemoryRecordsResponse> {
    private final BedrockAgentCoreClient client;
    private final RetrieveMemoryRecordsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public RetrieveMemoryRecordsIterable(BedrockAgentCoreClient client, RetrieveMemoryRecordsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new RetrieveMemoryRecordsResponseFetcher();
    }

    public Iterator<RetrieveMemoryRecordsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MemoryRecordSummary> memoryRecordSummaries() {
        Function<RetrieveMemoryRecordsResponse, Iterator> getIterator = response -> {
            if (response != null && response.memoryRecordSummaries() != null) {
                return response.memoryRecordSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class RetrieveMemoryRecordsResponseFetcher
    implements SyncPageFetcher<RetrieveMemoryRecordsResponse> {
        private RetrieveMemoryRecordsResponseFetcher() {
        }

        public boolean hasNextPage(RetrieveMemoryRecordsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public RetrieveMemoryRecordsResponse nextPage(RetrieveMemoryRecordsResponse previousPage) {
            if (previousPage == null) {
                return RetrieveMemoryRecordsIterable.this.client.retrieveMemoryRecords(RetrieveMemoryRecordsIterable.this.firstRequest);
            }
            return RetrieveMemoryRecordsIterable.this.client.retrieveMemoryRecords((RetrieveMemoryRecordsRequest)((Object)RetrieveMemoryRecordsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

