/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ContentBlockType {
    TEXT("text"),
    IMAGE("image"),
    RESOURCE("resource"),
    RESOURCE_LINK("resource_link"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ContentBlockType> VALUE_MAP;
    private final String value;

    private ContentBlockType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ContentBlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ContentBlockType> knownValues() {
        EnumSet<ContentBlockType> knownValues = EnumSet.allOf(ContentBlockType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ContentBlockType.class, ContentBlockType::toString);
    }
}

