/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.BedrockAgentCoreRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvokeAgentRuntimeRequest
extends BedrockAgentCoreRequest
implements ToCopyableBuilder<Builder, InvokeAgentRuntimeRequest> {
    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contentType").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::contentType)).setter(InvokeAgentRuntimeRequest.setter(Builder::contentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()}).build();
    private static final SdkField<String> ACCEPT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accept").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::accept)).setter(InvokeAgentRuntimeRequest.setter(Builder::accept)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Accept").build()}).build();
    private static final SdkField<String> MCP_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mcpSessionId").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::mcpSessionId)).setter(InvokeAgentRuntimeRequest.setter(Builder::mcpSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Session-Id").build()}).build();
    private static final SdkField<String> RUNTIME_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeSessionId").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::runtimeSessionId)).setter(InvokeAgentRuntimeRequest.setter(Builder::runtimeSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> MCP_PROTOCOL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mcpProtocolVersion").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::mcpProtocolVersion)).setter(InvokeAgentRuntimeRequest.setter(Builder::mcpProtocolVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Mcp-Protocol-Version").build()}).build();
    private static final SdkField<String> RUNTIME_USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runtimeUserId").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::runtimeUserId)).setter(InvokeAgentRuntimeRequest.setter(Builder::runtimeUserId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Bedrock-AgentCore-Runtime-User-Id").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::traceId)).setter(InvokeAgentRuntimeRequest.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amzn-Trace-Id").build()}).build();
    private static final SdkField<String> TRACE_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceParent").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::traceParent)).setter(InvokeAgentRuntimeRequest.setter(Builder::traceParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("traceparent").build()}).build();
    private static final SdkField<String> TRACE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceState").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::traceState)).setter(InvokeAgentRuntimeRequest.setter(Builder::traceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("tracestate").build()}).build();
    private static final SdkField<String> BAGGAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("baggage").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::baggage)).setter(InvokeAgentRuntimeRequest.setter(Builder::baggage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("baggage").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::agentRuntimeArn)).setter(InvokeAgentRuntimeRequest.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> QUALIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("qualifier").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::qualifier)).setter(InvokeAgentRuntimeRequest.setter(Builder::qualifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("qualifier").build()}).build();
    private static final SdkField<SdkBytes> PAYLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("payload").getter(InvokeAgentRuntimeRequest.getter(InvokeAgentRuntimeRequest::payload)).setter(InvokeAgentRuntimeRequest.setter(Builder::payload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("payload").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_TYPE_FIELD, ACCEPT_FIELD, MCP_SESSION_ID_FIELD, RUNTIME_SESSION_ID_FIELD, MCP_PROTOCOL_VERSION_FIELD, RUNTIME_USER_ID_FIELD, TRACE_ID_FIELD, TRACE_PARENT_FIELD, TRACE_STATE_FIELD, BAGGAGE_FIELD, AGENT_RUNTIME_ARN_FIELD, QUALIFIER_FIELD, PAYLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvokeAgentRuntimeRequest.memberNameToFieldInitializer();
    private final String contentType;
    private final String accept;
    private final String mcpSessionId;
    private final String runtimeSessionId;
    private final String mcpProtocolVersion;
    private final String runtimeUserId;
    private final String traceId;
    private final String traceParent;
    private final String traceState;
    private final String baggage;
    private final String agentRuntimeArn;
    private final String qualifier;
    private final SdkBytes payload;

    private InvokeAgentRuntimeRequest(BuilderImpl builder) {
        super(builder);
        this.contentType = builder.contentType;
        this.accept = builder.accept;
        this.mcpSessionId = builder.mcpSessionId;
        this.runtimeSessionId = builder.runtimeSessionId;
        this.mcpProtocolVersion = builder.mcpProtocolVersion;
        this.runtimeUserId = builder.runtimeUserId;
        this.traceId = builder.traceId;
        this.traceParent = builder.traceParent;
        this.traceState = builder.traceState;
        this.baggage = builder.baggage;
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.qualifier = builder.qualifier;
        this.payload = builder.payload;
    }

    public final String contentType() {
        return this.contentType;
    }

    public final String accept() {
        return this.accept;
    }

    public final String mcpSessionId() {
        return this.mcpSessionId;
    }

    public final String runtimeSessionId() {
        return this.runtimeSessionId;
    }

    public final String mcpProtocolVersion() {
        return this.mcpProtocolVersion;
    }

    public final String runtimeUserId() {
        return this.runtimeUserId;
    }

    public final String traceId() {
        return this.traceId;
    }

    public final String traceParent() {
        return this.traceParent;
    }

    public final String traceState() {
        return this.traceState;
    }

    public final String baggage() {
        return this.baggage;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String qualifier() {
        return this.qualifier;
    }

    public final SdkBytes payload() {
        return this.payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.contentType());
        hashCode = 31 * hashCode + Objects.hashCode(this.accept());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcpSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.mcpProtocolVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeUserId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceState());
        hashCode = 31 * hashCode + Objects.hashCode(this.baggage());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.qualifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.payload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRuntimeRequest)) {
            return false;
        }
        InvokeAgentRuntimeRequest other = (InvokeAgentRuntimeRequest)((Object)obj);
        return Objects.equals(this.contentType(), other.contentType()) && Objects.equals(this.accept(), other.accept()) && Objects.equals(this.mcpSessionId(), other.mcpSessionId()) && Objects.equals(this.runtimeSessionId(), other.runtimeSessionId()) && Objects.equals(this.mcpProtocolVersion(), other.mcpProtocolVersion()) && Objects.equals(this.runtimeUserId(), other.runtimeUserId()) && Objects.equals(this.traceId(), other.traceId()) && Objects.equals(this.traceParent(), other.traceParent()) && Objects.equals(this.traceState(), other.traceState()) && Objects.equals(this.baggage(), other.baggage()) && Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.qualifier(), other.qualifier()) && Objects.equals(this.payload(), other.payload());
    }

    public final String toString() {
        return ToString.builder((String)"InvokeAgentRuntimeRequest").add("ContentType", (Object)this.contentType()).add("Accept", (Object)this.accept()).add("McpSessionId", (Object)this.mcpSessionId()).add("RuntimeSessionId", (Object)this.runtimeSessionId()).add("McpProtocolVersion", (Object)this.mcpProtocolVersion()).add("RuntimeUserId", (Object)this.runtimeUserId()).add("TraceId", (Object)this.traceId()).add("TraceParent", (Object)this.traceParent()).add("TraceState", (Object)this.traceState()).add("Baggage", (Object)this.baggage()).add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("Qualifier", (Object)this.qualifier()).add("Payload", (Object)(this.payload() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contentType": {
                return Optional.ofNullable(clazz.cast(this.contentType()));
            }
            case "accept": {
                return Optional.ofNullable(clazz.cast(this.accept()));
            }
            case "mcpSessionId": {
                return Optional.ofNullable(clazz.cast(this.mcpSessionId()));
            }
            case "runtimeSessionId": {
                return Optional.ofNullable(clazz.cast(this.runtimeSessionId()));
            }
            case "mcpProtocolVersion": {
                return Optional.ofNullable(clazz.cast(this.mcpProtocolVersion()));
            }
            case "runtimeUserId": {
                return Optional.ofNullable(clazz.cast(this.runtimeUserId()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
            case "traceParent": {
                return Optional.ofNullable(clazz.cast(this.traceParent()));
            }
            case "traceState": {
                return Optional.ofNullable(clazz.cast(this.traceState()));
            }
            case "baggage": {
                return Optional.ofNullable(clazz.cast(this.baggage()));
            }
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "qualifier": {
                return Optional.ofNullable(clazz.cast(this.qualifier()));
            }
            case "payload": {
                return Optional.ofNullable(clazz.cast(this.payload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Content-Type", CONTENT_TYPE_FIELD);
        map.put("Accept", ACCEPT_FIELD);
        map.put("Mcp-Session-Id", MCP_SESSION_ID_FIELD);
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-Session-Id", RUNTIME_SESSION_ID_FIELD);
        map.put("Mcp-Protocol-Version", MCP_PROTOCOL_VERSION_FIELD);
        map.put("X-Amzn-Bedrock-AgentCore-Runtime-User-Id", RUNTIME_USER_ID_FIELD);
        map.put("X-Amzn-Trace-Id", TRACE_ID_FIELD);
        map.put("traceparent", TRACE_PARENT_FIELD);
        map.put("tracestate", TRACE_STATE_FIELD);
        map.put("baggage", BAGGAGE_FIELD);
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("qualifier", QUALIFIER_FIELD);
        map.put("payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRuntimeRequest, T> g) {
        return obj -> g.apply((InvokeAgentRuntimeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreRequest.BuilderImpl
    implements Builder {
        private String contentType;
        private String accept;
        private String mcpSessionId;
        private String runtimeSessionId;
        private String mcpProtocolVersion;
        private String runtimeUserId;
        private String traceId;
        private String traceParent;
        private String traceState;
        private String baggage;
        private String agentRuntimeArn;
        private String qualifier;
        private SdkBytes payload;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRuntimeRequest model) {
            super(model);
            this.contentType(model.contentType);
            this.accept(model.accept);
            this.mcpSessionId(model.mcpSessionId);
            this.runtimeSessionId(model.runtimeSessionId);
            this.mcpProtocolVersion(model.mcpProtocolVersion);
            this.runtimeUserId(model.runtimeUserId);
            this.traceId(model.traceId);
            this.traceParent(model.traceParent);
            this.traceState(model.traceState);
            this.baggage(model.baggage);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.qualifier(model.qualifier);
            this.payload(model.payload);
        }

        public final String getContentType() {
            return this.contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final String getAccept() {
            return this.accept;
        }

        public final void setAccept(String accept) {
            this.accept = accept;
        }

        @Override
        public final Builder accept(String accept) {
            this.accept = accept;
            return this;
        }

        public final String getMcpSessionId() {
            return this.mcpSessionId;
        }

        public final void setMcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
        }

        @Override
        public final Builder mcpSessionId(String mcpSessionId) {
            this.mcpSessionId = mcpSessionId;
            return this;
        }

        public final String getRuntimeSessionId() {
            return this.runtimeSessionId;
        }

        public final void setRuntimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
        }

        @Override
        public final Builder runtimeSessionId(String runtimeSessionId) {
            this.runtimeSessionId = runtimeSessionId;
            return this;
        }

        public final String getMcpProtocolVersion() {
            return this.mcpProtocolVersion;
        }

        public final void setMcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
        }

        @Override
        public final Builder mcpProtocolVersion(String mcpProtocolVersion) {
            this.mcpProtocolVersion = mcpProtocolVersion;
            return this;
        }

        public final String getRuntimeUserId() {
            return this.runtimeUserId;
        }

        public final void setRuntimeUserId(String runtimeUserId) {
            this.runtimeUserId = runtimeUserId;
        }

        @Override
        public final Builder runtimeUserId(String runtimeUserId) {
            this.runtimeUserId = runtimeUserId;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getTraceParent() {
            return this.traceParent;
        }

        public final void setTraceParent(String traceParent) {
            this.traceParent = traceParent;
        }

        @Override
        public final Builder traceParent(String traceParent) {
            this.traceParent = traceParent;
            return this;
        }

        public final String getTraceState() {
            return this.traceState;
        }

        public final void setTraceState(String traceState) {
            this.traceState = traceState;
        }

        @Override
        public final Builder traceState(String traceState) {
            this.traceState = traceState;
            return this;
        }

        public final String getBaggage() {
            return this.baggage;
        }

        public final void setBaggage(String baggage) {
            this.baggage = baggage;
        }

        @Override
        public final Builder baggage(String baggage) {
            this.baggage = baggage;
            return this;
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getQualifier() {
            return this.qualifier;
        }

        public final void setQualifier(String qualifier) {
            this.qualifier = qualifier;
        }

        @Override
        public final Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public final ByteBuffer getPayload() {
            return this.payload == null ? null : this.payload.asByteBuffer();
        }

        public final void setPayload(ByteBuffer payload) {
            this.payload(payload == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)payload));
        }

        @Override
        public final Builder payload(SdkBytes payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRuntimeRequest build() {
            return new InvokeAgentRuntimeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, InvokeAgentRuntimeRequest> {
        public Builder contentType(String var1);

        public Builder accept(String var1);

        public Builder mcpSessionId(String var1);

        public Builder runtimeSessionId(String var1);

        public Builder mcpProtocolVersion(String var1);

        public Builder runtimeUserId(String var1);

        public Builder traceId(String var1);

        public Builder traceParent(String var1);

        public Builder traceState(String var1);

        public Builder baggage(String var1);

        public Builder agentRuntimeArn(String var1);

        public Builder qualifier(String var1);

        public Builder payload(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

