/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcore.BedrockAgentCoreAsyncClient;
import software.amazon.awssdk.services.bedrockagentcore.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcore.model.ActorSummary;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsRequest;
import software.amazon.awssdk.services.bedrockagentcore.model.ListActorsResponse;

public class ListActorsPublisher
implements SdkPublisher<ListActorsResponse> {
    private final BedrockAgentCoreAsyncClient client;
    private final ListActorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListActorsPublisher(BedrockAgentCoreAsyncClient client, ListActorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListActorsPublisher(BedrockAgentCoreAsyncClient client, ListActorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListActorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListActorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ActorSummary> actorSummaries() {
        Function<ListActorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.actorSummaries() != null) {
                return response.actorSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListActorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListActorsResponseFetcher
    implements AsyncPageFetcher<ListActorsResponse> {
        private ListActorsResponseFetcher() {
        }

        public boolean hasNextPage(ListActorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListActorsResponse> nextPage(ListActorsResponse previousPage) {
            if (previousPage == null) {
                return ListActorsPublisher.this.client.listActors(ListActorsPublisher.this.firstRequest);
            }
            return ListActorsPublisher.this.client.listActors((ListActorsRequest)((Object)ListActorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

