/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcore.model.Conversational;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PayloadType
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PayloadType> {
    private static final SdkField<Conversational> CONVERSATIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("conversational").getter(PayloadType.getter(PayloadType::conversational)).setter(PayloadType.setter(Builder::conversational)).constructor(Conversational::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversational").build()}).build();
    private static final SdkField<Document> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("blob").getter(PayloadType.getter(PayloadType::blob)).setter(PayloadType.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSATIONAL_FIELD, BLOB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PayloadType.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Conversational conversational;
    private final Document blob;
    private final Type type;

    private PayloadType(BuilderImpl builder) {
        this.conversational = builder.conversational;
        this.blob = builder.blob;
        this.type = builder.type;
    }

    public final Conversational conversational() {
        return this.conversational;
    }

    public final Document blob() {
        return this.blob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.conversational());
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PayloadType)) {
            return false;
        }
        PayloadType other = (PayloadType)obj;
        return Objects.equals(this.conversational(), other.conversational()) && Objects.equals(this.blob(), other.blob());
    }

    public final String toString() {
        return ToString.builder((String)"PayloadType").add("Conversational", (Object)this.conversational()).add("Blob", (Object)this.blob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "conversational": {
                return Optional.ofNullable(clazz.cast(this.conversational()));
            }
            case "blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
        }
        return Optional.empty();
    }

    public static PayloadType fromConversational(Conversational conversational) {
        return (PayloadType)PayloadType.builder().conversational(conversational).build();
    }

    public static PayloadType fromConversational(Consumer<Conversational.Builder> conversational) {
        Conversational.Builder builder = Conversational.builder();
        conversational.accept(builder);
        return PayloadType.fromConversational((Conversational)builder.build());
    }

    public static PayloadType fromBlob(Document blob) {
        return (PayloadType)PayloadType.builder().blob(blob).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("conversational", CONVERSATIONAL_FIELD);
        map.put("blob", BLOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PayloadType, T> g) {
        return obj -> g.apply((PayloadType)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CONVERSATIONAL,
        BLOB,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Conversational conversational;
        private Document blob;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(PayloadType model) {
            this.conversational(model.conversational);
            this.blob(model.blob);
        }

        public final Conversational.Builder getConversational() {
            return this.conversational != null ? this.conversational.toBuilder() : null;
        }

        public final void setConversational(Conversational.BuilderImpl conversational) {
            Conversational oldValue = this.conversational;
            this.conversational = conversational != null ? conversational.build() : null;
            this.handleUnionValueChange(Type.CONVERSATIONAL, oldValue, this.conversational);
        }

        @Override
        public final Builder conversational(Conversational conversational) {
            Conversational oldValue = this.conversational;
            this.conversational = conversational;
            this.handleUnionValueChange(Type.CONVERSATIONAL, oldValue, this.conversational);
            return this;
        }

        public final Document getBlob() {
            return this.blob;
        }

        public final void setBlob(Document blob) {
            Document oldValue = this.blob;
            this.blob = blob;
            this.handleUnionValueChange(Type.BLOB, oldValue, this.blob);
        }

        @Override
        public final Builder blob(Document blob) {
            Document oldValue = this.blob;
            this.blob = blob;
            this.handleUnionValueChange(Type.BLOB, oldValue, this.blob);
            return this;
        }

        public PayloadType build() {
            return new PayloadType(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PayloadType> {
        public Builder conversational(Conversational var1);

        default public Builder conversational(Consumer<Conversational.Builder> conversational) {
            return this.conversational((Conversational)((Conversational.Builder)Conversational.builder().applyMutation(conversational)).build());
        }

        public Builder blob(Document var1);
    }
}

