/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.AutomationStream;
import software.amazon.awssdk.services.bedrockagentcore.model.LiveViewStream;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrowserSessionStream
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrowserSessionStream> {
    private static final SdkField<AutomationStream> AUTOMATION_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("automationStream").getter(BrowserSessionStream.getter(BrowserSessionStream::automationStream)).setter(BrowserSessionStream.setter(Builder::automationStream)).constructor(AutomationStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("automationStream").build()}).build();
    private static final SdkField<LiveViewStream> LIVE_VIEW_STREAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("liveViewStream").getter(BrowserSessionStream.getter(BrowserSessionStream::liveViewStream)).setter(BrowserSessionStream.setter(Builder::liveViewStream)).constructor(LiveViewStream::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("liveViewStream").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_STREAM_FIELD, LIVE_VIEW_STREAM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BrowserSessionStream.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomationStream automationStream;
    private final LiveViewStream liveViewStream;

    private BrowserSessionStream(BuilderImpl builder) {
        this.automationStream = builder.automationStream;
        this.liveViewStream = builder.liveViewStream;
    }

    public final AutomationStream automationStream() {
        return this.automationStream;
    }

    public final LiveViewStream liveViewStream() {
        return this.liveViewStream;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.automationStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.liveViewStream());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrowserSessionStream)) {
            return false;
        }
        BrowserSessionStream other = (BrowserSessionStream)obj;
        return Objects.equals(this.automationStream(), other.automationStream()) && Objects.equals(this.liveViewStream(), other.liveViewStream());
    }

    public final String toString() {
        return ToString.builder((String)"BrowserSessionStream").add("AutomationStream", (Object)this.automationStream()).add("LiveViewStream", (Object)this.liveViewStream()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "automationStream": {
                return Optional.ofNullable(clazz.cast(this.automationStream()));
            }
            case "liveViewStream": {
                return Optional.ofNullable(clazz.cast(this.liveViewStream()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("automationStream", AUTOMATION_STREAM_FIELD);
        map.put("liveViewStream", LIVE_VIEW_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BrowserSessionStream, T> g) {
        return obj -> g.apply((BrowserSessionStream)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomationStream automationStream;
        private LiveViewStream liveViewStream;

        private BuilderImpl() {
        }

        private BuilderImpl(BrowserSessionStream model) {
            this.automationStream(model.automationStream);
            this.liveViewStream(model.liveViewStream);
        }

        public final AutomationStream.Builder getAutomationStream() {
            return this.automationStream != null ? this.automationStream.toBuilder() : null;
        }

        public final void setAutomationStream(AutomationStream.BuilderImpl automationStream) {
            this.automationStream = automationStream != null ? automationStream.build() : null;
        }

        @Override
        public final Builder automationStream(AutomationStream automationStream) {
            this.automationStream = automationStream;
            return this;
        }

        public final LiveViewStream.Builder getLiveViewStream() {
            return this.liveViewStream != null ? this.liveViewStream.toBuilder() : null;
        }

        public final void setLiveViewStream(LiveViewStream.BuilderImpl liveViewStream) {
            this.liveViewStream = liveViewStream != null ? liveViewStream.build() : null;
        }

        @Override
        public final Builder liveViewStream(LiveViewStream liveViewStream) {
            this.liveViewStream = liveViewStream;
            return this;
        }

        public BrowserSessionStream build() {
            return new BrowserSessionStream(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrowserSessionStream> {
        public Builder automationStream(AutomationStream var1);

        default public Builder automationStream(Consumer<AutomationStream.Builder> automationStream) {
            return this.automationStream((AutomationStream)((AutomationStream.Builder)AutomationStream.builder().applyMutation(automationStream)).build());
        }

        public Builder liveViewStream(LiveViewStream var1);

        default public Builder liveViewStream(Consumer<LiveViewStream.Builder> liveViewStream) {
            return this.liveViewStream((LiveViewStream)((LiveViewStream.Builder)LiveViewStream.builder().applyMutation(liveViewStream)).build());
        }
    }
}

