/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcore.model;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcore.model.ResourceContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceContent> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ResourceContent.getter(ResourceContent::typeAsString)).setter(ResourceContent.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uri").getter(ResourceContent.getter(ResourceContent::uri)).setter(ResourceContent.setter(Builder::uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uri").build()}).build();
    private static final SdkField<String> MIME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("mimeType").getter(ResourceContent.getter(ResourceContent::mimeType)).setter(ResourceContent.setter(Builder::mimeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mimeType").build()}).build();
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ResourceContent.getter(ResourceContent::text)).setter(ResourceContent.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<SdkBytes> BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("blob").getter(ResourceContent.getter(ResourceContent::blob)).setter(ResourceContent.setter(Builder::blob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, URI_FIELD, MIME_TYPE_FIELD, TEXT_FIELD, BLOB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String uri;
    private final String mimeType;
    private final String text;
    private final SdkBytes blob;

    private ResourceContent(BuilderImpl builder) {
        this.type = builder.type;
        this.uri = builder.uri;
        this.mimeType = builder.mimeType;
        this.text = builder.text;
        this.blob = builder.blob;
    }

    public final ResourceContentType type() {
        return ResourceContentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String uri() {
        return this.uri;
    }

    public final String mimeType() {
        return this.mimeType;
    }

    public final String text() {
        return this.text;
    }

    public final SdkBytes blob() {
        return this.blob;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.mimeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.blob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceContent)) {
            return false;
        }
        ResourceContent other = (ResourceContent)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.uri(), other.uri()) && Objects.equals(this.mimeType(), other.mimeType()) && Objects.equals(this.text(), other.text()) && Objects.equals(this.blob(), other.blob());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceContent").add("Type", (Object)this.typeAsString()).add("Uri", (Object)this.uri()).add("MimeType", (Object)this.mimeType()).add("Text", (Object)this.text()).add("Blob", (Object)this.blob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "uri": {
                return Optional.ofNullable(clazz.cast(this.uri()));
            }
            case "mimeType": {
                return Optional.ofNullable(clazz.cast(this.mimeType()));
            }
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "blob": {
                return Optional.ofNullable(clazz.cast(this.blob()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("uri", URI_FIELD);
        map.put("mimeType", MIME_TYPE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("blob", BLOB_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceContent, T> g) {
        return obj -> g.apply((ResourceContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String uri;
        private String mimeType;
        private String text;
        private SdkBytes blob;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceContent model) {
            this.type(model.type);
            this.uri(model.uri);
            this.mimeType(model.mimeType);
            this.text(model.text);
            this.blob(model.blob);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ResourceContentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getUri() {
            return this.uri;
        }

        public final void setUri(String uri) {
            this.uri = uri;
        }

        @Override
        public final Builder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public final String getMimeType() {
            return this.mimeType;
        }

        public final void setMimeType(String mimeType) {
            this.mimeType = mimeType;
        }

        @Override
        public final Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final ByteBuffer getBlob() {
            return this.blob == null ? null : this.blob.asByteBuffer();
        }

        public final void setBlob(ByteBuffer blob) {
            this.blob(blob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)blob));
        }

        @Override
        public final Builder blob(SdkBytes blob) {
            this.blob = blob;
            return this;
        }

        public ResourceContent build() {
            return new ResourceContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceContent> {
        public Builder type(String var1);

        public Builder type(ResourceContentType var1);

        public Builder uri(String var1);

        public Builder mimeType(String var1);

        public Builder text(String var1);

        public Builder blob(SdkBytes var1);
    }
}

