/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.CuratedQueriesCopier;
import software.amazon.awssdk.services.bedrockagent.model.CuratedQuery;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTable;
import software.amazon.awssdk.services.bedrockagent.model.QueryGenerationTablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryGenerationContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QueryGenerationContext> {
    private static final SdkField<List<QueryGenerationTable>> TABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tables").getter(QueryGenerationContext.getter(QueryGenerationContext::tables)).setter(QueryGenerationContext.setter(Builder::tables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryGenerationTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CuratedQuery>> CURATED_QUERIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("curatedQueries").getter(QueryGenerationContext.getter(QueryGenerationContext::curatedQueries)).setter(QueryGenerationContext.setter(Builder::curatedQueries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("curatedQueries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CuratedQuery::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TABLES_FIELD, CURATED_QUERIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = QueryGenerationContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<QueryGenerationTable> tables;
    private final List<CuratedQuery> curatedQueries;

    private QueryGenerationContext(BuilderImpl builder) {
        this.tables = builder.tables;
        this.curatedQueries = builder.curatedQueries;
    }

    public final boolean hasTables() {
        return this.tables != null && !(this.tables instanceof SdkAutoConstructList);
    }

    public final List<QueryGenerationTable> tables() {
        return this.tables;
    }

    public final boolean hasCuratedQueries() {
        return this.curatedQueries != null && !(this.curatedQueries instanceof SdkAutoConstructList);
    }

    public final List<CuratedQuery> curatedQueries() {
        return this.curatedQueries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTables() ? this.tables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCuratedQueries() ? this.curatedQueries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryGenerationContext)) {
            return false;
        }
        QueryGenerationContext other = (QueryGenerationContext)obj;
        return this.hasTables() == other.hasTables() && Objects.equals(this.tables(), other.tables()) && this.hasCuratedQueries() == other.hasCuratedQueries() && Objects.equals(this.curatedQueries(), other.curatedQueries());
    }

    public final String toString() {
        return ToString.builder((String)"QueryGenerationContext").add("Tables", this.hasTables() ? this.tables() : null).add("CuratedQueries", this.hasCuratedQueries() ? this.curatedQueries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tables": {
                return Optional.ofNullable(clazz.cast(this.tables()));
            }
            case "curatedQueries": {
                return Optional.ofNullable(clazz.cast(this.curatedQueries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tables", TABLES_FIELD);
        map.put("curatedQueries", CURATED_QUERIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueryGenerationContext, T> g) {
        return obj -> g.apply((QueryGenerationContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<QueryGenerationTable> tables = DefaultSdkAutoConstructList.getInstance();
        private List<CuratedQuery> curatedQueries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(QueryGenerationContext model) {
            this.tables(model.tables);
            this.curatedQueries(model.curatedQueries);
        }

        public final List<QueryGenerationTable.Builder> getTables() {
            List<QueryGenerationTable.Builder> result = QueryGenerationTablesCopier.copyToBuilder(this.tables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTables(Collection<QueryGenerationTable.BuilderImpl> tables) {
            this.tables = QueryGenerationTablesCopier.copyFromBuilder(tables);
        }

        @Override
        public final Builder tables(Collection<QueryGenerationTable> tables) {
            this.tables = QueryGenerationTablesCopier.copy(tables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(QueryGenerationTable ... tables) {
            this.tables(Arrays.asList(tables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tables(Consumer<QueryGenerationTable.Builder> ... tables) {
            this.tables(Stream.of(tables).map(c -> (QueryGenerationTable)((QueryGenerationTable.Builder)QueryGenerationTable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<CuratedQuery.Builder> getCuratedQueries() {
            List<CuratedQuery.Builder> result = CuratedQueriesCopier.copyToBuilder(this.curatedQueries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCuratedQueries(Collection<CuratedQuery.BuilderImpl> curatedQueries) {
            this.curatedQueries = CuratedQueriesCopier.copyFromBuilder(curatedQueries);
        }

        @Override
        public final Builder curatedQueries(Collection<CuratedQuery> curatedQueries) {
            this.curatedQueries = CuratedQueriesCopier.copy(curatedQueries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder curatedQueries(CuratedQuery ... curatedQueries) {
            this.curatedQueries(Arrays.asList(curatedQueries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder curatedQueries(Consumer<CuratedQuery.Builder> ... curatedQueries) {
            this.curatedQueries(Stream.of(curatedQueries).map(c -> (CuratedQuery)((CuratedQuery.Builder)CuratedQuery.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public QueryGenerationContext build() {
            return new QueryGenerationContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QueryGenerationContext> {
        public Builder tables(Collection<QueryGenerationTable> var1);

        public Builder tables(QueryGenerationTable ... var1);

        public Builder tables(Consumer<QueryGenerationTable.Builder> ... var1);

        public Builder curatedQueries(Collection<CuratedQuery> var1);

        public Builder curatedQueries(CuratedQuery ... var1);

        public Builder curatedQueries(Consumer<CuratedQuery.Builder> ... var1);
    }
}

