/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.AdditionalModelRequestFieldsCopier;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBasePromptTemplate;
import software.amazon.awssdk.services.bedrockagent.model.PerformanceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.PromptInferenceConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseOrchestrationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseOrchestrationConfiguration> {
    private static final SdkField<KnowledgeBasePromptTemplate> PROMPT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("promptTemplate").getter(KnowledgeBaseOrchestrationConfiguration.getter(KnowledgeBaseOrchestrationConfiguration::promptTemplate)).setter(KnowledgeBaseOrchestrationConfiguration.setter(Builder::promptTemplate)).constructor(KnowledgeBasePromptTemplate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptTemplate").build()}).build();
    private static final SdkField<PromptInferenceConfiguration> INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfig").getter(KnowledgeBaseOrchestrationConfiguration.getter(KnowledgeBaseOrchestrationConfiguration::inferenceConfig)).setter(KnowledgeBaseOrchestrationConfiguration.setter(Builder::inferenceConfig)).constructor(PromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfig").build()}).build();
    private static final SdkField<Map<String, Document>> ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("additionalModelRequestFields").getter(KnowledgeBaseOrchestrationConfiguration.getter(KnowledgeBaseOrchestrationConfiguration::additionalModelRequestFields)).setter(KnowledgeBaseOrchestrationConfiguration.setter(Builder::additionalModelRequestFields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalModelRequestFields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<PerformanceConfiguration> PERFORMANCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("performanceConfig").getter(KnowledgeBaseOrchestrationConfiguration.getter(KnowledgeBaseOrchestrationConfiguration::performanceConfig)).setter(KnowledgeBaseOrchestrationConfiguration.setter(Builder::performanceConfig)).constructor(PerformanceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("performanceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TEMPLATE_FIELD, INFERENCE_CONFIG_FIELD, ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD, PERFORMANCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseOrchestrationConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final KnowledgeBasePromptTemplate promptTemplate;
    private final PromptInferenceConfiguration inferenceConfig;
    private final Map<String, Document> additionalModelRequestFields;
    private final PerformanceConfiguration performanceConfig;

    private KnowledgeBaseOrchestrationConfiguration(BuilderImpl builder) {
        this.promptTemplate = builder.promptTemplate;
        this.inferenceConfig = builder.inferenceConfig;
        this.additionalModelRequestFields = builder.additionalModelRequestFields;
        this.performanceConfig = builder.performanceConfig;
    }

    public final KnowledgeBasePromptTemplate promptTemplate() {
        return this.promptTemplate;
    }

    public final PromptInferenceConfiguration inferenceConfig() {
        return this.inferenceConfig;
    }

    public final boolean hasAdditionalModelRequestFields() {
        return this.additionalModelRequestFields != null && !(this.additionalModelRequestFields instanceof SdkAutoConstructMap);
    }

    public final Map<String, Document> additionalModelRequestFields() {
        return this.additionalModelRequestFields;
    }

    public final PerformanceConfiguration performanceConfig() {
        return this.performanceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseOrchestrationConfiguration)) {
            return false;
        }
        KnowledgeBaseOrchestrationConfiguration other = (KnowledgeBaseOrchestrationConfiguration)obj;
        return Objects.equals(this.promptTemplate(), other.promptTemplate()) && Objects.equals(this.inferenceConfig(), other.inferenceConfig()) && this.hasAdditionalModelRequestFields() == other.hasAdditionalModelRequestFields() && Objects.equals(this.additionalModelRequestFields(), other.additionalModelRequestFields()) && Objects.equals(this.performanceConfig(), other.performanceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseOrchestrationConfiguration").add("PromptTemplate", (Object)this.promptTemplate()).add("InferenceConfig", (Object)this.inferenceConfig()).add("AdditionalModelRequestFields", this.hasAdditionalModelRequestFields() ? this.additionalModelRequestFields() : null).add("PerformanceConfig", (Object)this.performanceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "promptTemplate": {
                return Optional.ofNullable(clazz.cast(this.promptTemplate()));
            }
            case "inferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfig()));
            }
            case "additionalModelRequestFields": {
                return Optional.ofNullable(clazz.cast(this.additionalModelRequestFields()));
            }
            case "performanceConfig": {
                return Optional.ofNullable(clazz.cast(this.performanceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("promptTemplate", PROMPT_TEMPLATE_FIELD);
        map.put("inferenceConfig", INFERENCE_CONFIG_FIELD);
        map.put("additionalModelRequestFields", ADDITIONAL_MODEL_REQUEST_FIELDS_FIELD);
        map.put("performanceConfig", PERFORMANCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseOrchestrationConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseOrchestrationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private KnowledgeBasePromptTemplate promptTemplate;
        private PromptInferenceConfiguration inferenceConfig;
        private Map<String, Document> additionalModelRequestFields = DefaultSdkAutoConstructMap.getInstance();
        private PerformanceConfiguration performanceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseOrchestrationConfiguration model) {
            this.promptTemplate(model.promptTemplate);
            this.inferenceConfig(model.inferenceConfig);
            this.additionalModelRequestFields(model.additionalModelRequestFields);
            this.performanceConfig(model.performanceConfig);
        }

        public final KnowledgeBasePromptTemplate.Builder getPromptTemplate() {
            return this.promptTemplate != null ? this.promptTemplate.toBuilder() : null;
        }

        public final void setPromptTemplate(KnowledgeBasePromptTemplate.BuilderImpl promptTemplate) {
            this.promptTemplate = promptTemplate != null ? promptTemplate.build() : null;
        }

        @Override
        public final Builder promptTemplate(KnowledgeBasePromptTemplate promptTemplate) {
            this.promptTemplate = promptTemplate;
            return this;
        }

        public final PromptInferenceConfiguration.Builder getInferenceConfig() {
            return this.inferenceConfig != null ? this.inferenceConfig.toBuilder() : null;
        }

        public final void setInferenceConfig(PromptInferenceConfiguration.BuilderImpl inferenceConfig) {
            this.inferenceConfig = inferenceConfig != null ? inferenceConfig.build() : null;
        }

        @Override
        public final Builder inferenceConfig(PromptInferenceConfiguration inferenceConfig) {
            this.inferenceConfig = inferenceConfig;
            return this;
        }

        public final Map<String, Document> getAdditionalModelRequestFields() {
            if (this.additionalModelRequestFields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.additionalModelRequestFields;
        }

        public final void setAdditionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
        }

        @Override
        public final Builder additionalModelRequestFields(Map<String, Document> additionalModelRequestFields) {
            this.additionalModelRequestFields = AdditionalModelRequestFieldsCopier.copy(additionalModelRequestFields);
            return this;
        }

        public final PerformanceConfiguration.Builder getPerformanceConfig() {
            return this.performanceConfig != null ? this.performanceConfig.toBuilder() : null;
        }

        public final void setPerformanceConfig(PerformanceConfiguration.BuilderImpl performanceConfig) {
            this.performanceConfig = performanceConfig != null ? performanceConfig.build() : null;
        }

        @Override
        public final Builder performanceConfig(PerformanceConfiguration performanceConfig) {
            this.performanceConfig = performanceConfig;
            return this;
        }

        public KnowledgeBaseOrchestrationConfiguration build() {
            return new KnowledgeBaseOrchestrationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseOrchestrationConfiguration> {
        public Builder promptTemplate(KnowledgeBasePromptTemplate var1);

        default public Builder promptTemplate(Consumer<KnowledgeBasePromptTemplate.Builder> promptTemplate) {
            return this.promptTemplate((KnowledgeBasePromptTemplate)((KnowledgeBasePromptTemplate.Builder)KnowledgeBasePromptTemplate.builder().applyMutation(promptTemplate)).build());
        }

        public Builder inferenceConfig(PromptInferenceConfiguration var1);

        default public Builder inferenceConfig(Consumer<PromptInferenceConfiguration.Builder> inferenceConfig) {
            return this.inferenceConfig((PromptInferenceConfiguration)((PromptInferenceConfiguration.Builder)PromptInferenceConfiguration.builder().applyMutation(inferenceConfig)).build());
        }

        public Builder additionalModelRequestFields(Map<String, Document> var1);

        public Builder performanceConfig(PerformanceConfiguration var1);

        default public Builder performanceConfig(Consumer<PerformanceConfiguration.Builder> performanceConfig) {
            return this.performanceConfig((PerformanceConfiguration)((PerformanceConfiguration.Builder)PerformanceConfiguration.builder().applyMutation(performanceConfig)).build());
        }
    }
}

