/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.ConfluenceAuthType;
import software.amazon.awssdk.services.bedrockagent.model.ConfluenceHostType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfluenceSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfluenceSourceConfiguration> {
    private static final SdkField<String> HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostUrl").getter(ConfluenceSourceConfiguration.getter(ConfluenceSourceConfiguration::hostUrl)).setter(ConfluenceSourceConfiguration.setter(Builder::hostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostUrl").build()}).build();
    private static final SdkField<String> HOST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostType").getter(ConfluenceSourceConfiguration.getter(ConfluenceSourceConfiguration::hostTypeAsString)).setter(ConfluenceSourceConfiguration.setter(Builder::hostType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostType").build()}).build();
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(ConfluenceSourceConfiguration.getter(ConfluenceSourceConfiguration::authTypeAsString)).setter(ConfluenceSourceConfiguration.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(ConfluenceSourceConfiguration.getter(ConfluenceSourceConfiguration::credentialsSecretArn)).setter(ConfluenceSourceConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_URL_FIELD, HOST_TYPE_FIELD, AUTH_TYPE_FIELD, CREDENTIALS_SECRET_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConfluenceSourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hostUrl;
    private final String hostType;
    private final String authType;
    private final String credentialsSecretArn;

    private ConfluenceSourceConfiguration(BuilderImpl builder) {
        this.hostUrl = builder.hostUrl;
        this.hostType = builder.hostType;
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
    }

    public final String hostUrl() {
        return this.hostUrl;
    }

    public final ConfluenceHostType hostType() {
        return ConfluenceHostType.fromValue(this.hostType);
    }

    public final String hostTypeAsString() {
        return this.hostType;
    }

    public final ConfluenceAuthType authType() {
        return ConfluenceAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hostUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfluenceSourceConfiguration)) {
            return false;
        }
        ConfluenceSourceConfiguration other = (ConfluenceSourceConfiguration)obj;
        return Objects.equals(this.hostUrl(), other.hostUrl()) && Objects.equals(this.hostTypeAsString(), other.hostTypeAsString()) && Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn());
    }

    public final String toString() {
        return ToString.builder((String)"ConfluenceSourceConfiguration").add("HostUrl", (Object)this.hostUrl()).add("HostType", (Object)this.hostTypeAsString()).add("AuthType", (Object)this.authTypeAsString()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hostUrl": {
                return Optional.ofNullable(clazz.cast(this.hostUrl()));
            }
            case "hostType": {
                return Optional.ofNullable(clazz.cast(this.hostTypeAsString()));
            }
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("hostUrl", HOST_URL_FIELD);
        map.put("hostType", HOST_TYPE_FIELD);
        map.put("authType", AUTH_TYPE_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfluenceSourceConfiguration, T> g) {
        return obj -> g.apply((ConfluenceSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hostUrl;
        private String hostType;
        private String authType;
        private String credentialsSecretArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfluenceSourceConfiguration model) {
            this.hostUrl(model.hostUrl);
            this.hostType(model.hostType);
            this.authType(model.authType);
            this.credentialsSecretArn(model.credentialsSecretArn);
        }

        public final String getHostUrl() {
            return this.hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public final String getHostType() {
            return this.hostType;
        }

        public final void setHostType(String hostType) {
            this.hostType = hostType;
        }

        @Override
        public final Builder hostType(String hostType) {
            this.hostType = hostType;
            return this;
        }

        @Override
        public final Builder hostType(ConfluenceHostType hostType) {
            this.hostType(hostType == null ? null : hostType.toString());
            return this;
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(ConfluenceAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public ConfluenceSourceConfiguration build() {
            return new ConfluenceSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfluenceSourceConfiguration> {
        public Builder hostUrl(String var1);

        public Builder hostType(String var1);

        public Builder hostType(ConfluenceHostType var1);

        public Builder authType(String var1);

        public Builder authType(ConfluenceAuthType var1);

        public Builder credentialsSecretArn(String var1);
    }
}

