/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration settings for processing video content in multimodal knowledge bases.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VideoConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VideoConfiguration.Builder, VideoConfiguration> {
    private static final SdkField<VideoSegmentationConfiguration> SEGMENTATION_CONFIGURATION_FIELD = SdkField
            .<VideoSegmentationConfiguration> builder(MarshallingType.SDK_POJO).memberName("segmentationConfiguration")
            .getter(getter(VideoConfiguration::segmentationConfiguration)).setter(setter(Builder::segmentationConfiguration))
            .constructor(VideoSegmentationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("segmentationConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SEGMENTATION_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VideoSegmentationConfiguration segmentationConfiguration;

    private VideoConfiguration(BuilderImpl builder) {
        this.segmentationConfiguration = builder.segmentationConfiguration;
    }

    /**
     * <p>
     * Configuration for segmenting video content during processing.
     * </p>
     * 
     * @return Configuration for segmenting video content during processing.
     */
    public final VideoSegmentationConfiguration segmentationConfiguration() {
        return segmentationConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(segmentationConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoConfiguration)) {
            return false;
        }
        VideoConfiguration other = (VideoConfiguration) obj;
        return Objects.equals(segmentationConfiguration(), other.segmentationConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VideoConfiguration").add("SegmentationConfiguration", segmentationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "segmentationConfiguration":
            return Optional.ofNullable(clazz.cast(segmentationConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("segmentationConfiguration", SEGMENTATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VideoConfiguration, T> g) {
        return obj -> g.apply((VideoConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VideoConfiguration> {
        /**
         * <p>
         * Configuration for segmenting video content during processing.
         * </p>
         * 
         * @param segmentationConfiguration
         *        Configuration for segmenting video content during processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder segmentationConfiguration(VideoSegmentationConfiguration segmentationConfiguration);

        /**
         * <p>
         * Configuration for segmenting video content during processing.
         * </p>
         * This is a convenience method that creates an instance of the {@link VideoSegmentationConfiguration.Builder}
         * avoiding the need to create one manually via {@link VideoSegmentationConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VideoSegmentationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #segmentationConfiguration(VideoSegmentationConfiguration)}.
         * 
         * @param segmentationConfiguration
         *        a consumer that will call methods on {@link VideoSegmentationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #segmentationConfiguration(VideoSegmentationConfiguration)
         */
        default Builder segmentationConfiguration(Consumer<VideoSegmentationConfiguration.Builder> segmentationConfiguration) {
            return segmentationConfiguration(VideoSegmentationConfiguration.builder().applyMutation(segmentationConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private VideoSegmentationConfiguration segmentationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(VideoConfiguration model) {
            segmentationConfiguration(model.segmentationConfiguration);
        }

        public final VideoSegmentationConfiguration.Builder getSegmentationConfiguration() {
            return segmentationConfiguration != null ? segmentationConfiguration.toBuilder() : null;
        }

        public final void setSegmentationConfiguration(VideoSegmentationConfiguration.BuilderImpl segmentationConfiguration) {
            this.segmentationConfiguration = segmentationConfiguration != null ? segmentationConfiguration.build() : null;
        }

        @Override
        public final Builder segmentationConfiguration(VideoSegmentationConfiguration segmentationConfiguration) {
            this.segmentationConfiguration = segmentationConfiguration;
            return this;
        }

        @Override
        public VideoConfiguration build() {
            return new VideoConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
