/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the storage configuration of the knowledge base for S3 vectors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3VectorsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<S3VectorsConfiguration.Builder, S3VectorsConfiguration> {
    private static final SdkField<String> VECTOR_BUCKET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorBucketArn").getter(getter(S3VectorsConfiguration::vectorBucketArn))
            .setter(setter(Builder::vectorBucketArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorBucketArn").build()).build();

    private static final SdkField<String> INDEX_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexArn").getter(getter(S3VectorsConfiguration::indexArn)).setter(setter(Builder::indexArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexArn").build()).build();

    private static final SdkField<String> INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("indexName").getter(getter(S3VectorsConfiguration::indexName)).setter(setter(Builder::indexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("indexName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VECTOR_BUCKET_ARN_FIELD,
            INDEX_ARN_FIELD, INDEX_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vectorBucketArn;

    private final String indexArn;

    private final String indexName;

    private S3VectorsConfiguration(BuilderImpl builder) {
        this.vectorBucketArn = builder.vectorBucketArn;
        this.indexArn = builder.indexArn;
        this.indexName = builder.indexName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the S3 bucket where vector embeddings are stored. This bucket contains the
     * vector data used by the knowledge base.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the S3 bucket where vector embeddings are stored. This bucket contains
     *         the vector data used by the knowledge base.
     */
    public final String vectorBucketArn() {
        return vectorBucketArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the vector index used for the knowledge base. This ARN identifies the specific
     * vector index resource within Amazon Bedrock.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the vector index used for the knowledge base. This ARN identifies the
     *         specific vector index resource within Amazon Bedrock.
     */
    public final String indexArn() {
        return indexArn;
    }

    /**
     * <p>
     * The name of the vector index used for the knowledge base. This name identifies the vector index within the Amazon
     * Bedrock service.
     * </p>
     * 
     * @return The name of the vector index used for the knowledge base. This name identifies the vector index within
     *         the Amazon Bedrock service.
     */
    public final String indexName() {
        return indexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vectorBucketArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexArn());
        hashCode = 31 * hashCode + Objects.hashCode(indexName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3VectorsConfiguration)) {
            return false;
        }
        S3VectorsConfiguration other = (S3VectorsConfiguration) obj;
        return Objects.equals(vectorBucketArn(), other.vectorBucketArn()) && Objects.equals(indexArn(), other.indexArn())
                && Objects.equals(indexName(), other.indexName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3VectorsConfiguration")
                .add("VectorBucketArn", vectorBucketArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IndexArn", indexArn() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IndexName", indexName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vectorBucketArn":
            return Optional.ofNullable(clazz.cast(vectorBucketArn()));
        case "indexArn":
            return Optional.ofNullable(clazz.cast(indexArn()));
        case "indexName":
            return Optional.ofNullable(clazz.cast(indexName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vectorBucketArn", VECTOR_BUCKET_ARN_FIELD);
        map.put("indexArn", INDEX_ARN_FIELD);
        map.put("indexName", INDEX_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3VectorsConfiguration, T> g) {
        return obj -> g.apply((S3VectorsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3VectorsConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the S3 bucket where vector embeddings are stored. This bucket contains the
         * vector data used by the knowledge base.
         * </p>
         * 
         * @param vectorBucketArn
         *        The Amazon Resource Name (ARN) of the S3 bucket where vector embeddings are stored. This bucket
         *        contains the vector data used by the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorBucketArn(String vectorBucketArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the vector index used for the knowledge base. This ARN identifies the
         * specific vector index resource within Amazon Bedrock.
         * </p>
         * 
         * @param indexArn
         *        The Amazon Resource Name (ARN) of the vector index used for the knowledge base. This ARN identifies
         *        the specific vector index resource within Amazon Bedrock.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexArn(String indexArn);

        /**
         * <p>
         * The name of the vector index used for the knowledge base. This name identifies the vector index within the
         * Amazon Bedrock service.
         * </p>
         * 
         * @param indexName
         *        The name of the vector index used for the knowledge base. This name identifies the vector index within
         *        the Amazon Bedrock service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexName(String indexName);
    }

    static final class BuilderImpl implements Builder {
        private String vectorBucketArn;

        private String indexArn;

        private String indexName;

        private BuilderImpl() {
        }

        private BuilderImpl(S3VectorsConfiguration model) {
            vectorBucketArn(model.vectorBucketArn);
            indexArn(model.indexArn);
            indexName(model.indexName);
        }

        public final String getVectorBucketArn() {
            return vectorBucketArn;
        }

        public final void setVectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
        }

        @Override
        public final Builder vectorBucketArn(String vectorBucketArn) {
            this.vectorBucketArn = vectorBucketArn;
            return this;
        }

        public final String getIndexArn() {
            return indexArn;
        }

        public final void setIndexArn(String indexArn) {
            this.indexArn = indexArn;
        }

        @Override
        public final Builder indexArn(String indexArn) {
            this.indexArn = indexArn;
            return this;
        }

        public final String getIndexName() {
            return indexName;
        }

        public final void setIndexName(String indexName) {
            this.indexName = indexName;
        }

        @Override
        public final Builder indexName(String indexName) {
            this.indexName = indexName;
            return this;
        }

        @Override
        public S3VectorsConfiguration build() {
            return new S3VectorsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
