/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies how metadata fields should be handled during the reranking process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataConfigurationForReranking implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataConfigurationForReranking.Builder, MetadataConfigurationForReranking> {
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("selectionMode").getter(getter(MetadataConfigurationForReranking::selectionModeAsString))
            .setter(setter(Builder::selectionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()).build();

    private static final SdkField<RerankingMetadataSelectiveModeConfiguration> SELECTIVE_MODE_CONFIGURATION_FIELD = SdkField
            .<RerankingMetadataSelectiveModeConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("selectiveModeConfiguration")
            .getter(getter(MetadataConfigurationForReranking::selectiveModeConfiguration))
            .setter(setter(Builder::selectiveModeConfiguration))
            .constructor(RerankingMetadataSelectiveModeConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectiveModeConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_MODE_FIELD,
            SELECTIVE_MODE_CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String selectionMode;

    private final RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration;

    private MetadataConfigurationForReranking(BuilderImpl builder) {
        this.selectionMode = builder.selectionMode;
        this.selectiveModeConfiguration = builder.selectiveModeConfiguration;
    }

    /**
     * <p>
     * The mode for selecting metadata fields for reranking.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionMode}
     * will return {@link RerankingMetadataSelectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectionModeAsString}.
     * </p>
     * 
     * @return The mode for selecting metadata fields for reranking.
     * @see RerankingMetadataSelectionMode
     */
    public final RerankingMetadataSelectionMode selectionMode() {
        return RerankingMetadataSelectionMode.fromValue(selectionMode);
    }

    /**
     * <p>
     * The mode for selecting metadata fields for reranking.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionMode}
     * will return {@link RerankingMetadataSelectionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectionModeAsString}.
     * </p>
     * 
     * @return The mode for selecting metadata fields for reranking.
     * @see RerankingMetadataSelectionMode
     */
    public final String selectionModeAsString() {
        return selectionMode;
    }

    /**
     * <p>
     * The configuration for selective metadata field inclusion or exclusion during reranking.
     * </p>
     * 
     * @return The configuration for selective metadata field inclusion or exclusion during reranking.
     */
    public final RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration() {
        return selectiveModeConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(selectiveModeConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfigurationForReranking)) {
            return false;
        }
        MetadataConfigurationForReranking other = (MetadataConfigurationForReranking) obj;
        return Objects.equals(selectionModeAsString(), other.selectionModeAsString())
                && Objects.equals(selectiveModeConfiguration(), other.selectiveModeConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataConfigurationForReranking").add("SelectionMode", selectionModeAsString())
                .add("SelectiveModeConfiguration", selectiveModeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "selectionMode":
            return Optional.ofNullable(clazz.cast(selectionModeAsString()));
        case "selectiveModeConfiguration":
            return Optional.ofNullable(clazz.cast(selectiveModeConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("selectionMode", SELECTION_MODE_FIELD);
        map.put("selectiveModeConfiguration", SELECTIVE_MODE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfigurationForReranking, T> g) {
        return obj -> g.apply((MetadataConfigurationForReranking) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataConfigurationForReranking> {
        /**
         * <p>
         * The mode for selecting metadata fields for reranking.
         * </p>
         * 
         * @param selectionMode
         *        The mode for selecting metadata fields for reranking.
         * @see RerankingMetadataSelectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankingMetadataSelectionMode
         */
        Builder selectionMode(String selectionMode);

        /**
         * <p>
         * The mode for selecting metadata fields for reranking.
         * </p>
         * 
         * @param selectionMode
         *        The mode for selecting metadata fields for reranking.
         * @see RerankingMetadataSelectionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RerankingMetadataSelectionMode
         */
        Builder selectionMode(RerankingMetadataSelectionMode selectionMode);

        /**
         * <p>
         * The configuration for selective metadata field inclusion or exclusion during reranking.
         * </p>
         * 
         * @param selectiveModeConfiguration
         *        The configuration for selective metadata field inclusion or exclusion during reranking.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration);

        /**
         * <p>
         * The configuration for selective metadata field inclusion or exclusion during reranking.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RerankingMetadataSelectiveModeConfiguration.Builder} avoiding the need to create one manually via
         * {@link RerankingMetadataSelectiveModeConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RerankingMetadataSelectiveModeConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration)}.
         * 
         * @param selectiveModeConfiguration
         *        a consumer that will call methods on {@link RerankingMetadataSelectiveModeConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration)
         */
        default Builder selectiveModeConfiguration(
                Consumer<RerankingMetadataSelectiveModeConfiguration.Builder> selectiveModeConfiguration) {
            return selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration.builder()
                    .applyMutation(selectiveModeConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String selectionMode;

        private RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfigurationForReranking model) {
            selectionMode(model.selectionMode);
            selectiveModeConfiguration(model.selectiveModeConfiguration);
        }

        public final String getSelectionMode() {
            return selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public final Builder selectionMode(RerankingMetadataSelectionMode selectionMode) {
            this.selectionMode(selectionMode == null ? null : selectionMode.toString());
            return this;
        }

        public final RerankingMetadataSelectiveModeConfiguration.Builder getSelectiveModeConfiguration() {
            return selectiveModeConfiguration != null ? selectiveModeConfiguration.toBuilder() : null;
        }

        public final void setSelectiveModeConfiguration(
                RerankingMetadataSelectiveModeConfiguration.BuilderImpl selectiveModeConfiguration) {
            this.selectiveModeConfiguration = selectiveModeConfiguration != null ? selectiveModeConfiguration.build() : null;
        }

        @Override
        public final Builder selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration) {
            this.selectiveModeConfiguration = selectiveModeConfiguration;
            return this;
        }

        @Override
        public MetadataConfigurationForReranking build() {
            return new MetadataConfigurationForReranking(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
