/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the value of the metadata attribute. Choose a <code>type</code> and include the field that corresponds to
 * it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetadataAttributeValue implements SdkPojo, Serializable,
        ToCopyableBuilder<MetadataAttributeValue.Builder, MetadataAttributeValue> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(MetadataAttributeValue::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Double> NUMBER_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("numberValue").getter(getter(MetadataAttributeValue::numberValue)).setter(setter(Builder::numberValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberValue").build()).build();

    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(MetadataAttributeValue::booleanValue))
            .setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(MetadataAttributeValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final SdkField<List<String>> STRING_LIST_VALUE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("stringListValue")
            .getter(getter(MetadataAttributeValue::stringListValue))
            .setter(setter(Builder::stringListValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringListValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD,
            NUMBER_VALUE_FIELD, BOOLEAN_VALUE_FIELD, STRING_VALUE_FIELD, STRING_LIST_VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Double numberValue;

    private final Boolean booleanValue;

    private final String stringValue;

    private final List<String> stringListValue;

    private MetadataAttributeValue(BuilderImpl builder) {
        this.type = builder.type;
        this.numberValue = builder.numberValue;
        this.booleanValue = builder.booleanValue;
        this.stringValue = builder.stringValue;
        this.stringListValue = builder.stringListValue;
    }

    /**
     * <p>
     * The type of the metadata attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata attribute.
     * @see MetadataValueType
     */
    public final MetadataValueType type() {
        return MetadataValueType.fromValue(type);
    }

    /**
     * <p>
     * The type of the metadata attribute.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link MetadataValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the metadata attribute.
     * @see MetadataValueType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The value of the numeric metadata attribute.
     * </p>
     * 
     * @return The value of the numeric metadata attribute.
     */
    public final Double numberValue() {
        return numberValue;
    }

    /**
     * <p>
     * The value of the Boolean metadata attribute.
     * </p>
     * 
     * @return The value of the Boolean metadata attribute.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * The value of the string metadata attribute.
     * </p>
     * 
     * @return The value of the string metadata attribute.
     */
    public final String stringValue() {
        return stringValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the StringListValue property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStringListValue() {
        return stringListValue != null && !(stringListValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings that define the value of the metadata attribute.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStringListValue} method.
     * </p>
     * 
     * @return An array of strings that define the value of the metadata attribute.
     */
    public final List<String> stringListValue() {
        return stringListValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(numberValue());
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasStringListValue() ? stringListValue() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataAttributeValue)) {
            return false;
        }
        MetadataAttributeValue other = (MetadataAttributeValue) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(numberValue(), other.numberValue())
                && Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(stringValue(), other.stringValue())
                && hasStringListValue() == other.hasStringListValue()
                && Objects.equals(stringListValue(), other.stringListValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetadataAttributeValue").add("Type", typeAsString())
                .add("NumberValue", numberValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BooleanValue", booleanValue())
                .add("StringValue", stringValue() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StringListValue", stringListValue() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "numberValue":
            return Optional.ofNullable(clazz.cast(numberValue()));
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        case "stringListValue":
            return Optional.ofNullable(clazz.cast(stringListValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("numberValue", NUMBER_VALUE_FIELD);
        map.put("booleanValue", BOOLEAN_VALUE_FIELD);
        map.put("stringValue", STRING_VALUE_FIELD);
        map.put("stringListValue", STRING_LIST_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataAttributeValue, T> g) {
        return obj -> g.apply((MetadataAttributeValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetadataAttributeValue> {
        /**
         * <p>
         * The type of the metadata attribute.
         * </p>
         * 
         * @param type
         *        The type of the metadata attribute.
         * @see MetadataValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataValueType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the metadata attribute.
         * </p>
         * 
         * @param type
         *        The type of the metadata attribute.
         * @see MetadataValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MetadataValueType
         */
        Builder type(MetadataValueType type);

        /**
         * <p>
         * The value of the numeric metadata attribute.
         * </p>
         * 
         * @param numberValue
         *        The value of the numeric metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberValue(Double numberValue);

        /**
         * <p>
         * The value of the Boolean metadata attribute.
         * </p>
         * 
         * @param booleanValue
         *        The value of the Boolean metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * The value of the string metadata attribute.
         * </p>
         * 
         * @param stringValue
         *        The value of the string metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);

        /**
         * <p>
         * An array of strings that define the value of the metadata attribute.
         * </p>
         * 
         * @param stringListValue
         *        An array of strings that define the value of the metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(Collection<String> stringListValue);

        /**
         * <p>
         * An array of strings that define the value of the metadata attribute.
         * </p>
         * 
         * @param stringListValue
         *        An array of strings that define the value of the metadata attribute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringListValue(String... stringListValue);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Double numberValue;

        private Boolean booleanValue;

        private String stringValue;

        private List<String> stringListValue = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataAttributeValue model) {
            type(model.type);
            numberValue(model.numberValue);
            booleanValue(model.booleanValue);
            stringValue(model.stringValue);
            stringListValue(model.stringListValue);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetadataValueType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getNumberValue() {
            return numberValue;
        }

        public final void setNumberValue(Double numberValue) {
            this.numberValue = numberValue;
        }

        @Override
        public final Builder numberValue(Double numberValue) {
            this.numberValue = numberValue;
            return this;
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        public final Collection<String> getStringListValue() {
            if (stringListValue instanceof SdkAutoConstructList) {
                return null;
            }
            return stringListValue;
        }

        public final void setStringListValue(Collection<String> stringListValue) {
            this.stringListValue = MetadataAttributeValueStringListValueListCopier.copy(stringListValue);
        }

        @Override
        public final Builder stringListValue(Collection<String> stringListValue) {
            this.stringListValue = MetadataAttributeValueStringListValueListCopier.copy(stringListValue);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringListValue(String... stringListValue) {
            stringListValue(Arrays.asList(stringListValue));
            return this;
        }

        @Override
        public MetadataAttributeValue build() {
            return new MetadataAttributeValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
