/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class IngestKnowledgeBaseDocumentsRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<IngestKnowledgeBaseDocumentsRequest.Builder, IngestKnowledgeBaseDocumentsRequest> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("knowledgeBaseId").getter(getter(IngestKnowledgeBaseDocumentsRequest::knowledgeBaseId))
            .setter(setter(Builder::knowledgeBaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceId").getter(getter(IngestKnowledgeBaseDocumentsRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(IngestKnowledgeBaseDocumentsRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<KnowledgeBaseDocument>> DOCUMENTS_FIELD = SdkField
            .<List<KnowledgeBaseDocument>> builder(MarshallingType.LIST)
            .memberName("documents")
            .getter(getter(IngestKnowledgeBaseDocumentsRequest::documents))
            .setter(setter(Builder::documents))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documents").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<KnowledgeBaseDocument> builder(MarshallingType.SDK_POJO)
                                            .constructor(KnowledgeBaseDocument::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD,
            DATA_SOURCE_ID_FIELD, CLIENT_TOKEN_FIELD, DOCUMENTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String knowledgeBaseId;

    private final String dataSourceId;

    private final String clientToken;

    private final List<KnowledgeBaseDocument> documents;

    private IngestKnowledgeBaseDocumentsRequest(BuilderImpl builder) {
        super(builder);
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.dataSourceId = builder.dataSourceId;
        this.clientToken = builder.clientToken;
        this.documents = builder.documents;
    }

    /**
     * <p>
     * The unique identifier of the knowledge base to ingest the documents into.
     * </p>
     * 
     * @return The unique identifier of the knowledge base to ingest the documents into.
     */
    public final String knowledgeBaseId() {
        return knowledgeBaseId;
    }

    /**
     * <p>
     * The unique identifier of the data source connected to the knowledge base that you're adding documents to.
     * </p>
     * 
     * @return The unique identifier of the data source connected to the knowledge base that you're adding documents to.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     * idempotency</a>.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
     *         this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
     *         idempotency</a>.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Documents property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDocuments() {
        return documents != null && !(documents instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects, each of which contains information about the documents to add.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDocuments} method.
     * </p>
     * 
     * @return A list of objects, each of which contains information about the documents to add.
     */
    public final List<KnowledgeBaseDocument> documents() {
        return documents;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasDocuments() ? documents() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestKnowledgeBaseDocumentsRequest)) {
            return false;
        }
        IngestKnowledgeBaseDocumentsRequest other = (IngestKnowledgeBaseDocumentsRequest) obj;
        return Objects.equals(knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(clientToken(), other.clientToken()) && hasDocuments() == other.hasDocuments()
                && Objects.equals(documents(), other.documents());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IngestKnowledgeBaseDocumentsRequest").add("KnowledgeBaseId", knowledgeBaseId())
                .add("DataSourceId", dataSourceId()).add("ClientToken", clientToken())
                .add("Documents", hasDocuments() ? documents() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "knowledgeBaseId":
            return Optional.ofNullable(clazz.cast(knowledgeBaseId()));
        case "dataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "documents":
            return Optional.ofNullable(clazz.cast(documents()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("documents", DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IngestKnowledgeBaseDocumentsRequest, T> g) {
        return obj -> g.apply((IngestKnowledgeBaseDocumentsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, IngestKnowledgeBaseDocumentsRequest> {
        /**
         * <p>
         * The unique identifier of the knowledge base to ingest the documents into.
         * </p>
         * 
         * @param knowledgeBaseId
         *        The unique identifier of the knowledge base to ingest the documents into.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder knowledgeBaseId(String knowledgeBaseId);

        /**
         * <p>
         * The unique identifier of the data source connected to the knowledge base that you're adding documents to.
         * </p>
         * 
         * @param dataSourceId
         *        The unique identifier of the data source connected to the knowledge base that you're adding documents
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error. For more
         * information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         * idempotency</a>.
         * </p>
         * 
         * @param clientToken
         *        A unique, case-sensitive identifier to ensure that the API request completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">Ensuring
         *        idempotency</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * A list of objects, each of which contains information about the documents to add.
         * </p>
         * 
         * @param documents
         *        A list of objects, each of which contains information about the documents to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(Collection<KnowledgeBaseDocument> documents);

        /**
         * <p>
         * A list of objects, each of which contains information about the documents to add.
         * </p>
         * 
         * @param documents
         *        A list of objects, each of which contains information about the documents to add.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documents(KnowledgeBaseDocument... documents);

        /**
         * <p>
         * A list of objects, each of which contains information about the documents to add.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocument.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocument#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocument.Builder#build()} is called
         * immediately and its result is passed to {@link #documents(List<KnowledgeBaseDocument>)}.
         * 
         * @param documents
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseDocument.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #documents(java.util.Collection<KnowledgeBaseDocument>)
         */
        Builder documents(Consumer<KnowledgeBaseDocument.Builder>... documents);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String knowledgeBaseId;

        private String dataSourceId;

        private String clientToken;

        private List<KnowledgeBaseDocument> documents = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestKnowledgeBaseDocumentsRequest model) {
            super(model);
            knowledgeBaseId(model.knowledgeBaseId);
            dataSourceId(model.dataSourceId);
            clientToken(model.clientToken);
            documents(model.documents);
        }

        public final String getKnowledgeBaseId() {
            return knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<KnowledgeBaseDocument.Builder> getDocuments() {
            List<KnowledgeBaseDocument.Builder> result = KnowledgeBaseDocumentsCopier.copyToBuilder(this.documents);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDocuments(Collection<KnowledgeBaseDocument.BuilderImpl> documents) {
            this.documents = KnowledgeBaseDocumentsCopier.copyFromBuilder(documents);
        }

        @Override
        public final Builder documents(Collection<KnowledgeBaseDocument> documents) {
            this.documents = KnowledgeBaseDocumentsCopier.copy(documents);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(KnowledgeBaseDocument... documents) {
            documents(Arrays.asList(documents));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder documents(Consumer<KnowledgeBaseDocument.Builder>... documents) {
            documents(Stream.of(documents).map(c -> KnowledgeBaseDocument.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public IngestKnowledgeBaseDocumentsRequest build() {
            return new IngestKnowledgeBaseDocumentsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
