/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The vector configuration details for the Bedrock embeddings model.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BedrockEmbeddingModelConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<BedrockEmbeddingModelConfiguration.Builder, BedrockEmbeddingModelConfiguration> {
    private static final SdkField<Integer> DIMENSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dimensions").getter(getter(BedrockEmbeddingModelConfiguration::dimensions))
            .setter(setter(Builder::dimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dimensions").build()).build();

    private static final SdkField<String> EMBEDDING_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("embeddingDataType").getter(getter(BedrockEmbeddingModelConfiguration::embeddingDataTypeAsString))
            .setter(setter(Builder::embeddingDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataType").build()).build();

    private static final SdkField<List<AudioConfiguration>> AUDIO_FIELD = SdkField
            .<List<AudioConfiguration>> builder(MarshallingType.LIST)
            .memberName("audio")
            .getter(getter(BedrockEmbeddingModelConfiguration::audio))
            .setter(setter(Builder::audio))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("audio").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AudioConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(AudioConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VideoConfiguration>> VIDEO_FIELD = SdkField
            .<List<VideoConfiguration>> builder(MarshallingType.LIST)
            .memberName("video")
            .getter(getter(BedrockEmbeddingModelConfiguration::video))
            .setter(setter(Builder::video))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("video").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VideoConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(VideoConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIMENSIONS_FIELD,
            EMBEDDING_DATA_TYPE_FIELD, AUDIO_FIELD, VIDEO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dimensions;

    private final String embeddingDataType;

    private final List<AudioConfiguration> audio;

    private final List<VideoConfiguration> video;

    private BedrockEmbeddingModelConfiguration(BuilderImpl builder) {
        this.dimensions = builder.dimensions;
        this.embeddingDataType = builder.embeddingDataType;
        this.audio = builder.audio;
        this.video = builder.video;
    }

    /**
     * <p>
     * The dimensions details for the vector configuration used on the Bedrock embeddings model.
     * </p>
     * 
     * @return The dimensions details for the vector configuration used on the Bedrock embeddings model.
     */
    public final Integer dimensions() {
        return dimensions;
    }

    /**
     * <p>
     * The data type for the vectors when using a model to convert text into vector embeddings. The model must support
     * the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is
     * supported by most models for vector embeddings. See <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings
     * models</a> for information on the available models and their vector data types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #embeddingDataType}
     * will return {@link EmbeddingDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #embeddingDataTypeAsString}.
     * </p>
     * 
     * @return The data type for the vectors when using a model to convert text into vector embeddings. The model must
     *         support the specified data type for vector embeddings. Floating-point (float32) is the default data type,
     *         and is supported by most models for vector embeddings. See <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
     *         embeddings models</a> for information on the available models and their vector data types.
     * @see EmbeddingDataType
     */
    public final EmbeddingDataType embeddingDataType() {
        return EmbeddingDataType.fromValue(embeddingDataType);
    }

    /**
     * <p>
     * The data type for the vectors when using a model to convert text into vector embeddings. The model must support
     * the specified data type for vector embeddings. Floating-point (float32) is the default data type, and is
     * supported by most models for vector embeddings. See <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported embeddings
     * models</a> for information on the available models and their vector data types.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #embeddingDataType}
     * will return {@link EmbeddingDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #embeddingDataTypeAsString}.
     * </p>
     * 
     * @return The data type for the vectors when using a model to convert text into vector embeddings. The model must
     *         support the specified data type for vector embeddings. Floating-point (float32) is the default data type,
     *         and is supported by most models for vector embeddings. See <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
     *         embeddings models</a> for information on the available models and their vector data types.
     * @see EmbeddingDataType
     */
    public final String embeddingDataTypeAsString() {
        return embeddingDataType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Audio property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasAudio() {
        return audio != null && !(audio instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for processing audio content in multimodal knowledge bases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAudio} method.
     * </p>
     * 
     * @return Configuration settings for processing audio content in multimodal knowledge bases.
     */
    public final List<AudioConfiguration> audio() {
        return audio;
    }

    /**
     * For responses, this returns true if the service returned a value for the Video property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasVideo() {
        return video != null && !(video instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for processing video content in multimodal knowledge bases.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVideo} method.
     * </p>
     * 
     * @return Configuration settings for processing video content in multimodal knowledge bases.
     */
    public final List<VideoConfiguration> video() {
        return video;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dimensions());
        hashCode = 31 * hashCode + Objects.hashCode(embeddingDataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAudio() ? audio() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVideo() ? video() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BedrockEmbeddingModelConfiguration)) {
            return false;
        }
        BedrockEmbeddingModelConfiguration other = (BedrockEmbeddingModelConfiguration) obj;
        return Objects.equals(dimensions(), other.dimensions())
                && Objects.equals(embeddingDataTypeAsString(), other.embeddingDataTypeAsString())
                && hasAudio() == other.hasAudio() && Objects.equals(audio(), other.audio()) && hasVideo() == other.hasVideo()
                && Objects.equals(video(), other.video());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BedrockEmbeddingModelConfiguration").add("Dimensions", dimensions())
                .add("EmbeddingDataType", embeddingDataTypeAsString()).add("Audio", hasAudio() ? audio() : null)
                .add("Video", hasVideo() ? video() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dimensions":
            return Optional.ofNullable(clazz.cast(dimensions()));
        case "embeddingDataType":
            return Optional.ofNullable(clazz.cast(embeddingDataTypeAsString()));
        case "audio":
            return Optional.ofNullable(clazz.cast(audio()));
        case "video":
            return Optional.ofNullable(clazz.cast(video()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dimensions", DIMENSIONS_FIELD);
        map.put("embeddingDataType", EMBEDDING_DATA_TYPE_FIELD);
        map.put("audio", AUDIO_FIELD);
        map.put("video", VIDEO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BedrockEmbeddingModelConfiguration, T> g) {
        return obj -> g.apply((BedrockEmbeddingModelConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BedrockEmbeddingModelConfiguration> {
        /**
         * <p>
         * The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * </p>
         * 
         * @param dimensions
         *        The dimensions details for the vector configuration used on the Bedrock embeddings model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensions(Integer dimensions);

        /**
         * <p>
         * The data type for the vectors when using a model to convert text into vector embeddings. The model must
         * support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and
         * is supported by most models for vector embeddings. See <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         * embeddings models</a> for information on the available models and their vector data types.
         * </p>
         * 
         * @param embeddingDataType
         *        The data type for the vectors when using a model to convert text into vector embeddings. The model
         *        must support the specified data type for vector embeddings. Floating-point (float32) is the default
         *        data type, and is supported by most models for vector embeddings. See <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         *        embeddings models</a> for information on the available models and their vector data types.
         * @see EmbeddingDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingDataType
         */
        Builder embeddingDataType(String embeddingDataType);

        /**
         * <p>
         * The data type for the vectors when using a model to convert text into vector embeddings. The model must
         * support the specified data type for vector embeddings. Floating-point (float32) is the default data type, and
         * is supported by most models for vector embeddings. See <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         * embeddings models</a> for information on the available models and their vector data types.
         * </p>
         * 
         * @param embeddingDataType
         *        The data type for the vectors when using a model to convert text into vector embeddings. The model
         *        must support the specified data type for vector embeddings. Floating-point (float32) is the default
         *        data type, and is supported by most models for vector embeddings. See <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-supported.html">Supported
         *        embeddings models</a> for information on the available models and their vector data types.
         * @see EmbeddingDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EmbeddingDataType
         */
        Builder embeddingDataType(EmbeddingDataType embeddingDataType);

        /**
         * <p>
         * Configuration settings for processing audio content in multimodal knowledge bases.
         * </p>
         * 
         * @param audio
         *        Configuration settings for processing audio content in multimodal knowledge bases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(Collection<AudioConfiguration> audio);

        /**
         * <p>
         * Configuration settings for processing audio content in multimodal knowledge bases.
         * </p>
         * 
         * @param audio
         *        Configuration settings for processing audio content in multimodal knowledge bases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder audio(AudioConfiguration... audio);

        /**
         * <p>
         * Configuration settings for processing audio content in multimodal knowledge bases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AudioConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AudioConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AudioConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #audio(List<AudioConfiguration>)}.
         * 
         * @param audio
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AudioConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #audio(java.util.Collection<AudioConfiguration>)
         */
        Builder audio(Consumer<AudioConfiguration.Builder>... audio);

        /**
         * <p>
         * Configuration settings for processing video content in multimodal knowledge bases.
         * </p>
         * 
         * @param video
         *        Configuration settings for processing video content in multimodal knowledge bases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(Collection<VideoConfiguration> video);

        /**
         * <p>
         * Configuration settings for processing video content in multimodal knowledge bases.
         * </p>
         * 
         * @param video
         *        Configuration settings for processing video content in multimodal knowledge bases.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder video(VideoConfiguration... video);

        /**
         * <p>
         * Configuration settings for processing video content in multimodal knowledge bases.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.VideoConfiguration.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.VideoConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.VideoConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #video(List<VideoConfiguration>)}.
         * 
         * @param video
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.VideoConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #video(java.util.Collection<VideoConfiguration>)
         */
        Builder video(Consumer<VideoConfiguration.Builder>... video);
    }

    static final class BuilderImpl implements Builder {
        private Integer dimensions;

        private String embeddingDataType;

        private List<AudioConfiguration> audio = DefaultSdkAutoConstructList.getInstance();

        private List<VideoConfiguration> video = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BedrockEmbeddingModelConfiguration model) {
            dimensions(model.dimensions);
            embeddingDataType(model.embeddingDataType);
            audio(model.audio);
            video(model.video);
        }

        public final Integer getDimensions() {
            return dimensions;
        }

        public final void setDimensions(Integer dimensions) {
            this.dimensions = dimensions;
        }

        @Override
        public final Builder dimensions(Integer dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public final String getEmbeddingDataType() {
            return embeddingDataType;
        }

        public final void setEmbeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
        }

        @Override
        public final Builder embeddingDataType(String embeddingDataType) {
            this.embeddingDataType = embeddingDataType;
            return this;
        }

        @Override
        public final Builder embeddingDataType(EmbeddingDataType embeddingDataType) {
            this.embeddingDataType(embeddingDataType == null ? null : embeddingDataType.toString());
            return this;
        }

        public final List<AudioConfiguration.Builder> getAudio() {
            List<AudioConfiguration.Builder> result = AudioConfigurationsCopier.copyToBuilder(this.audio);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAudio(Collection<AudioConfiguration.BuilderImpl> audio) {
            this.audio = AudioConfigurationsCopier.copyFromBuilder(audio);
        }

        @Override
        public final Builder audio(Collection<AudioConfiguration> audio) {
            this.audio = AudioConfigurationsCopier.copy(audio);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audio(AudioConfiguration... audio) {
            audio(Arrays.asList(audio));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder audio(Consumer<AudioConfiguration.Builder>... audio) {
            audio(Stream.of(audio).map(c -> AudioConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VideoConfiguration.Builder> getVideo() {
            List<VideoConfiguration.Builder> result = VideoConfigurationsCopier.copyToBuilder(this.video);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVideo(Collection<VideoConfiguration.BuilderImpl> video) {
            this.video = VideoConfigurationsCopier.copyFromBuilder(video);
        }

        @Override
        public final Builder video(Collection<VideoConfiguration> video) {
            this.video = VideoConfigurationsCopier.copy(video);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder video(VideoConfiguration... video) {
            video(Arrays.asList(video));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder video(Consumer<VideoConfiguration.Builder>... video) {
            video(Stream.of(video).map(c -> VideoConfiguration.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BedrockEmbeddingModelConfiguration build() {
            return new BedrockEmbeddingModelConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
