/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for segmenting audio content during multimodal knowledge base ingestion. Determines how audio files are
 * divided into chunks for processing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AudioSegmentationConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AudioSegmentationConfiguration.Builder, AudioSegmentationConfiguration> {
    private static final SdkField<Integer> FIXED_LENGTH_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("fixedLengthDuration").getter(getter(AudioSegmentationConfiguration::fixedLengthDuration))
            .setter(setter(Builder::fixedLengthDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fixedLengthDuration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIXED_LENGTH_DURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer fixedLengthDuration;

    private AudioSegmentationConfiguration(BuilderImpl builder) {
        this.fixedLengthDuration = builder.fixedLengthDuration;
    }

    /**
     * <p>
     * The duration in seconds for each audio segment. Audio files will be divided into chunks of this length for
     * processing.
     * </p>
     * 
     * @return The duration in seconds for each audio segment. Audio files will be divided into chunks of this length
     *         for processing.
     */
    public final Integer fixedLengthDuration() {
        return fixedLengthDuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fixedLengthDuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioSegmentationConfiguration)) {
            return false;
        }
        AudioSegmentationConfiguration other = (AudioSegmentationConfiguration) obj;
        return Objects.equals(fixedLengthDuration(), other.fixedLengthDuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AudioSegmentationConfiguration").add("FixedLengthDuration", fixedLengthDuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fixedLengthDuration":
            return Optional.ofNullable(clazz.cast(fixedLengthDuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fixedLengthDuration", FIXED_LENGTH_DURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioSegmentationConfiguration, T> g) {
        return obj -> g.apply((AudioSegmentationConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AudioSegmentationConfiguration> {
        /**
         * <p>
         * The duration in seconds for each audio segment. Audio files will be divided into chunks of this length for
         * processing.
         * </p>
         * 
         * @param fixedLengthDuration
         *        The duration in seconds for each audio segment. Audio files will be divided into chunks of this length
         *        for processing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fixedLengthDuration(Integer fixedLengthDuration);
    }

    static final class BuilderImpl implements Builder {
        private Integer fixedLengthDuration;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioSegmentationConfiguration model) {
            fixedLengthDuration(model.fixedLengthDuration);
        }

        public final Integer getFixedLengthDuration() {
            return fixedLengthDuration;
        }

        public final void setFixedLengthDuration(Integer fixedLengthDuration) {
            this.fixedLengthDuration = fixedLengthDuration;
        }

        @Override
        public final Builder fixedLengthDuration(Integer fixedLengthDuration) {
            this.fixedLengthDuration = fixedLengthDuration;
            return this;
        }

        @Override
        public AudioSegmentationConfiguration build() {
            return new AudioSegmentationConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
