/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.OpenSearchManagedClusterFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenSearchManagedClusterConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenSearchManagedClusterConfiguration> {
    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainEndpoint").getter(OpenSearchManagedClusterConfiguration.getter(OpenSearchManagedClusterConfiguration::domainEndpoint)).setter(OpenSearchManagedClusterConfiguration.setter(Builder::domainEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEndpoint").build()}).build();
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainArn").getter(OpenSearchManagedClusterConfiguration.getter(OpenSearchManagedClusterConfiguration::domainArn)).setter(OpenSearchManagedClusterConfiguration.setter(Builder::domainArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()}).build();
    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vectorIndexName").getter(OpenSearchManagedClusterConfiguration.getter(OpenSearchManagedClusterConfiguration::vectorIndexName)).setter(OpenSearchManagedClusterConfiguration.setter(Builder::vectorIndexName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()}).build();
    private static final SdkField<OpenSearchManagedClusterFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(OpenSearchManagedClusterConfiguration.getter(OpenSearchManagedClusterConfiguration::fieldMapping)).setter(OpenSearchManagedClusterConfiguration.setter(Builder::fieldMapping)).constructor(OpenSearchManagedClusterFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ENDPOINT_FIELD, DOMAIN_ARN_FIELD, VECTOR_INDEX_NAME_FIELD, FIELD_MAPPING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OpenSearchManagedClusterConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String domainEndpoint;
    private final String domainArn;
    private final String vectorIndexName;
    private final OpenSearchManagedClusterFieldMapping fieldMapping;

    private OpenSearchManagedClusterConfiguration(BuilderImpl builder) {
        this.domainEndpoint = builder.domainEndpoint;
        this.domainArn = builder.domainArn;
        this.vectorIndexName = builder.vectorIndexName;
        this.fieldMapping = builder.fieldMapping;
    }

    public final String domainEndpoint() {
        return this.domainEndpoint;
    }

    public final String domainArn() {
        return this.domainArn;
    }

    public final String vectorIndexName() {
        return this.vectorIndexName;
    }

    public final OpenSearchManagedClusterFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchManagedClusterConfiguration)) {
            return false;
        }
        OpenSearchManagedClusterConfiguration other = (OpenSearchManagedClusterConfiguration)obj;
        return Objects.equals(this.domainEndpoint(), other.domainEndpoint()) && Objects.equals(this.domainArn(), other.domainArn()) && Objects.equals(this.vectorIndexName(), other.vectorIndexName()) && Objects.equals(this.fieldMapping(), other.fieldMapping());
    }

    public final String toString() {
        return ToString.builder((String)"OpenSearchManagedClusterConfiguration").add("DomainEndpoint", (Object)this.domainEndpoint()).add("DomainArn", (Object)this.domainArn()).add("VectorIndexName", (Object)(this.vectorIndexName() == null ? null : "*** Sensitive Data Redacted ***")).add("FieldMapping", (Object)this.fieldMapping()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainEndpoint": {
                return Optional.ofNullable(clazz.cast(this.domainEndpoint()));
            }
            case "domainArn": {
                return Optional.ofNullable(clazz.cast(this.domainArn()));
            }
            case "vectorIndexName": {
                return Optional.ofNullable(clazz.cast(this.vectorIndexName()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainEndpoint", DOMAIN_ENDPOINT_FIELD);
        map.put("domainArn", DOMAIN_ARN_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchManagedClusterConfiguration, T> g) {
        return obj -> g.apply((OpenSearchManagedClusterConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainEndpoint;
        private String domainArn;
        private String vectorIndexName;
        private OpenSearchManagedClusterFieldMapping fieldMapping;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchManagedClusterConfiguration model) {
            this.domainEndpoint(model.domainEndpoint);
            this.domainArn(model.domainArn);
            this.vectorIndexName(model.vectorIndexName);
            this.fieldMapping(model.fieldMapping);
        }

        public final String getDomainEndpoint() {
            return this.domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final String getDomainArn() {
            return this.domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getVectorIndexName() {
            return this.vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        public final OpenSearchManagedClusterFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(OpenSearchManagedClusterFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(OpenSearchManagedClusterFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public OpenSearchManagedClusterConfiguration build() {
            return new OpenSearchManagedClusterConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenSearchManagedClusterConfiguration> {
        public Builder domainEndpoint(String var1);

        public Builder domainArn(String var1);

        public Builder vectorIndexName(String var1);

        public Builder fieldMapping(OpenSearchManagedClusterFieldMapping var1);

        default public Builder fieldMapping(Consumer<OpenSearchManagedClusterFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((OpenSearchManagedClusterFieldMapping)((OpenSearchManagedClusterFieldMapping.Builder)OpenSearchManagedClusterFieldMapping.builder().applyMutation(fieldMapping)).build());
        }
    }
}

