/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.DataDeletionPolicy;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.ServerSideEncryptionConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.VectorIngestionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::clientToken)).setter(CreateDataSourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATA_DELETION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataDeletionPolicy").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::dataDeletionPolicyAsString)).setter(CreateDataSourceRequest.setter(Builder::dataDeletionPolicy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataDeletionPolicy").build()}).build();
    private static final SdkField<DataSourceConfiguration> DATA_SOURCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataSourceConfiguration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::dataSourceConfiguration)).setter(CreateDataSourceRequest.setter(Builder::dataSourceConfiguration)).constructor(DataSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::description)).setter(CreateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::knowledgeBaseId)).setter(CreateDataSourceRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::name)).setter(CreateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ServerSideEncryptionConfiguration> SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serverSideEncryptionConfiguration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::serverSideEncryptionConfiguration)).setter(CreateDataSourceRequest.setter(Builder::serverSideEncryptionConfiguration)).constructor(ServerSideEncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverSideEncryptionConfiguration").build()}).build();
    private static final SdkField<VectorIngestionConfiguration> VECTOR_INGESTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vectorIngestionConfiguration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::vectorIngestionConfiguration)).setter(CreateDataSourceRequest.setter(Builder::vectorIngestionConfiguration)).constructor(VectorIngestionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIngestionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DATA_DELETION_POLICY_FIELD, DATA_SOURCE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_ID_FIELD, NAME_FIELD, SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD, VECTOR_INGESTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateDataSourceRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String dataDeletionPolicy;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final String description;
    private final String knowledgeBaseId;
    private final String name;
    private final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
    private final VectorIngestionConfiguration vectorIngestionConfiguration;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dataDeletionPolicy = builder.dataDeletionPolicy;
        this.dataSourceConfiguration = builder.dataSourceConfiguration;
        this.description = builder.description;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.name = builder.name;
        this.serverSideEncryptionConfiguration = builder.serverSideEncryptionConfiguration;
        this.vectorIngestionConfiguration = builder.vectorIngestionConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DataDeletionPolicy dataDeletionPolicy() {
        return DataDeletionPolicy.fromValue(this.dataDeletionPolicy);
    }

    public final String dataDeletionPolicyAsString() {
        return this.dataDeletionPolicy;
    }

    public final DataSourceConfiguration dataSourceConfiguration() {
        return this.dataSourceConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String name() {
        return this.name;
    }

    public final ServerSideEncryptionConfiguration serverSideEncryptionConfiguration() {
        return this.serverSideEncryptionConfiguration;
    }

    public final VectorIngestionConfiguration vectorIngestionConfiguration() {
        return this.vectorIngestionConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataDeletionPolicyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverSideEncryptionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.vectorIngestionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dataDeletionPolicyAsString(), other.dataDeletionPolicyAsString()) && Objects.equals(this.dataSourceConfiguration(), other.dataSourceConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.serverSideEncryptionConfiguration(), other.serverSideEncryptionConfiguration()) && Objects.equals(this.vectorIngestionConfiguration(), other.vectorIngestionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceRequest").add("ClientToken", (Object)this.clientToken()).add("DataDeletionPolicy", (Object)this.dataDeletionPolicyAsString()).add("DataSourceConfiguration", (Object)this.dataSourceConfiguration()).add("Description", (Object)this.description()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Name", (Object)this.name()).add("ServerSideEncryptionConfiguration", (Object)this.serverSideEncryptionConfiguration()).add("VectorIngestionConfiguration", (Object)this.vectorIngestionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "dataDeletionPolicy": {
                return Optional.ofNullable(clazz.cast(this.dataDeletionPolicyAsString()));
            }
            case "dataSourceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataSourceConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "serverSideEncryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.serverSideEncryptionConfiguration()));
            }
            case "vectorIngestionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.vectorIngestionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("dataDeletionPolicy", DATA_DELETION_POLICY_FIELD);
        map.put("dataSourceConfiguration", DATA_SOURCE_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("serverSideEncryptionConfiguration", SERVER_SIDE_ENCRYPTION_CONFIGURATION_FIELD);
        map.put("vectorIngestionConfiguration", VECTOR_INGESTION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String dataDeletionPolicy;
        private DataSourceConfiguration dataSourceConfiguration;
        private String description;
        private String knowledgeBaseId;
        private String name;
        private ServerSideEncryptionConfiguration serverSideEncryptionConfiguration;
        private VectorIngestionConfiguration vectorIngestionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dataDeletionPolicy(model.dataDeletionPolicy);
            this.dataSourceConfiguration(model.dataSourceConfiguration);
            this.description(model.description);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.name(model.name);
            this.serverSideEncryptionConfiguration(model.serverSideEncryptionConfiguration);
            this.vectorIngestionConfiguration(model.vectorIngestionConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDataDeletionPolicy() {
            return this.dataDeletionPolicy;
        }

        public final void setDataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
        }

        @Override
        public final Builder dataDeletionPolicy(String dataDeletionPolicy) {
            this.dataDeletionPolicy = dataDeletionPolicy;
            return this;
        }

        @Override
        public final Builder dataDeletionPolicy(DataDeletionPolicy dataDeletionPolicy) {
            this.dataDeletionPolicy(dataDeletionPolicy == null ? null : dataDeletionPolicy.toString());
            return this;
        }

        public final DataSourceConfiguration.Builder getDataSourceConfiguration() {
            return this.dataSourceConfiguration != null ? this.dataSourceConfiguration.toBuilder() : null;
        }

        public final void setDataSourceConfiguration(DataSourceConfiguration.BuilderImpl dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration != null ? dataSourceConfiguration.build() : null;
        }

        @Override
        public final Builder dataSourceConfiguration(DataSourceConfiguration dataSourceConfiguration) {
            this.dataSourceConfiguration = dataSourceConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ServerSideEncryptionConfiguration.Builder getServerSideEncryptionConfiguration() {
            return this.serverSideEncryptionConfiguration != null ? this.serverSideEncryptionConfiguration.toBuilder() : null;
        }

        public final void setServerSideEncryptionConfiguration(ServerSideEncryptionConfiguration.BuilderImpl serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration != null ? serverSideEncryptionConfiguration.build() : null;
        }

        @Override
        public final Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration serverSideEncryptionConfiguration) {
            this.serverSideEncryptionConfiguration = serverSideEncryptionConfiguration;
            return this;
        }

        public final VectorIngestionConfiguration.Builder getVectorIngestionConfiguration() {
            return this.vectorIngestionConfiguration != null ? this.vectorIngestionConfiguration.toBuilder() : null;
        }

        public final void setVectorIngestionConfiguration(VectorIngestionConfiguration.BuilderImpl vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration != null ? vectorIngestionConfiguration.build() : null;
        }

        @Override
        public final Builder vectorIngestionConfiguration(VectorIngestionConfiguration vectorIngestionConfiguration) {
            this.vectorIngestionConfiguration = vectorIngestionConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder clientToken(String var1);

        public Builder dataDeletionPolicy(String var1);

        public Builder dataDeletionPolicy(DataDeletionPolicy var1);

        public Builder dataSourceConfiguration(DataSourceConfiguration var1);

        default public Builder dataSourceConfiguration(Consumer<DataSourceConfiguration.Builder> dataSourceConfiguration) {
            return this.dataSourceConfiguration((DataSourceConfiguration)((DataSourceConfiguration.Builder)DataSourceConfiguration.builder().applyMutation(dataSourceConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder name(String var1);

        public Builder serverSideEncryptionConfiguration(ServerSideEncryptionConfiguration var1);

        default public Builder serverSideEncryptionConfiguration(Consumer<ServerSideEncryptionConfiguration.Builder> serverSideEncryptionConfiguration) {
            return this.serverSideEncryptionConfiguration((ServerSideEncryptionConfiguration)((ServerSideEncryptionConfiguration.Builder)ServerSideEncryptionConfiguration.builder().applyMutation(serverSideEncryptionConfiguration)).build());
        }

        public Builder vectorIngestionConfiguration(VectorIngestionConfiguration var1);

        default public Builder vectorIngestionConfiguration(Consumer<VectorIngestionConfiguration.Builder> vectorIngestionConfiguration) {
            return this.vectorIngestionConfiguration((VectorIngestionConfiguration)((VectorIngestionConfiguration.Builder)VectorIngestionConfiguration.builder().applyMutation(vectorIngestionConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

