/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilter;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobFiltersCopier;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobSortBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListIngestionJobsRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, ListIngestionJobsRequest> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::dataSourceId)).setter(ListIngestionJobsRequest.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("dataSourceId").build()}).build();
    private static final SdkField<List<IngestionJobFilter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("filters").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::filters)).setter(ListIngestionJobsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IngestionJobFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::knowledgeBaseId)).setter(ListIngestionJobsRequest.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::maxResults)).setter(ListIngestionJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::nextToken)).setter(ListIngestionJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<IngestionJobSortBy> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sortBy").getter(ListIngestionJobsRequest.getter(ListIngestionJobsRequest::sortBy)).setter(ListIngestionJobsRequest.setter(Builder::sortBy)).constructor(IngestionJobSortBy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, FILTERS_FIELD, KNOWLEDGE_BASE_ID_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListIngestionJobsRequest.memberNameToFieldInitializer();
    private final String dataSourceId;
    private final List<IngestionJobFilter> filters;
    private final String knowledgeBaseId;
    private final Integer maxResults;
    private final String nextToken;
    private final IngestionJobSortBy sortBy;

    private ListIngestionJobsRequest(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.filters = builder.filters;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sortBy = builder.sortBy;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<IngestionJobFilter> filters() {
        return this.filters;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final IngestionJobSortBy sortBy() {
        return this.sortBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListIngestionJobsRequest)) {
            return false;
        }
        ListIngestionJobsRequest other = (ListIngestionJobsRequest)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sortBy(), other.sortBy());
    }

    public final String toString() {
        return ToString.builder((String)"ListIngestionJobsRequest").add("DataSourceId", (Object)this.dataSourceId()).add("Filters", this.hasFilters() ? this.filters() : null).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SortBy", (Object)this.sortBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sortBy": {
                return Optional.ofNullable(clazz.cast(this.sortBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataSourceId", DATA_SOURCE_ID_FIELD);
        map.put("filters", FILTERS_FIELD);
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("sortBy", SORT_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListIngestionJobsRequest, T> g) {
        return obj -> g.apply((ListIngestionJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private List<IngestionJobFilter> filters = DefaultSdkAutoConstructList.getInstance();
        private String knowledgeBaseId;
        private Integer maxResults;
        private String nextToken;
        private IngestionJobSortBy sortBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ListIngestionJobsRequest model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.filters(model.filters);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sortBy(model.sortBy);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final List<IngestionJobFilter.Builder> getFilters() {
            List<IngestionJobFilter.Builder> result = IngestionJobFiltersCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<IngestionJobFilter.BuilderImpl> filters) {
            this.filters = IngestionJobFiltersCopier.copyFromBuilder(filters);
        }

        @Override
        public final Builder filters(Collection<IngestionJobFilter> filters) {
            this.filters = IngestionJobFiltersCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(IngestionJobFilter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<IngestionJobFilter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (IngestionJobFilter)((IngestionJobFilter.Builder)IngestionJobFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final IngestionJobSortBy.Builder getSortBy() {
            return this.sortBy != null ? this.sortBy.toBuilder() : null;
        }

        public final void setSortBy(IngestionJobSortBy.BuilderImpl sortBy) {
            this.sortBy = sortBy != null ? sortBy.build() : null;
        }

        @Override
        public final Builder sortBy(IngestionJobSortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListIngestionJobsRequest build() {
            return new ListIngestionJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListIngestionJobsRequest> {
        public Builder dataSourceId(String var1);

        public Builder filters(Collection<IngestionJobFilter> var1);

        public Builder filters(IngestionJobFilter ... var1);

        public Builder filters(Consumer<IngestionJobFilter.Builder> ... var1);

        public Builder knowledgeBaseId(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sortBy(IngestionJobSortBy var1);

        default public Builder sortBy(Consumer<IngestionJobSortBy.Builder> sortBy) {
            return this.sortBy((IngestionJobSortBy)((IngestionJobSortBy.Builder)IngestionJobSortBy.builder().applyMutation(sortBy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

