/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A custom processing step for documents moving through a data source ingestion pipeline. To process documents after
 * they have been converted into chunks, set the step to apply to <code>POST_CHUNKING</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Transformation implements SdkPojo, Serializable, ToCopyableBuilder<Transformation.Builder, Transformation> {
    private static final SdkField<String> STEP_TO_APPLY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepToApply").getter(getter(Transformation::stepToApplyAsString)).setter(setter(Builder::stepToApply))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepToApply").build()).build();

    private static final SdkField<TransformationFunction> TRANSFORMATION_FUNCTION_FIELD = SdkField
            .<TransformationFunction> builder(MarshallingType.SDK_POJO).memberName("transformationFunction")
            .getter(getter(Transformation::transformationFunction)).setter(setter(Builder::transformationFunction))
            .constructor(TransformationFunction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transformationFunction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_TO_APPLY_FIELD,
            TRANSFORMATION_FUNCTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepToApply;

    private final TransformationFunction transformationFunction;

    private Transformation(BuilderImpl builder) {
        this.stepToApply = builder.stepToApply;
        this.transformationFunction = builder.transformationFunction;
    }

    /**
     * <p>
     * When the service applies the transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepToApply} will
     * return {@link StepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepToApplyAsString}.
     * </p>
     * 
     * @return When the service applies the transformation.
     * @see StepType
     */
    public final StepType stepToApply() {
        return StepType.fromValue(stepToApply);
    }

    /**
     * <p>
     * When the service applies the transformation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepToApply} will
     * return {@link StepType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepToApplyAsString}.
     * </p>
     * 
     * @return When the service applies the transformation.
     * @see StepType
     */
    public final String stepToApplyAsString() {
        return stepToApply;
    }

    /**
     * <p>
     * A Lambda function that processes documents.
     * </p>
     * 
     * @return A Lambda function that processes documents.
     */
    public final TransformationFunction transformationFunction() {
        return transformationFunction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepToApplyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transformationFunction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Transformation)) {
            return false;
        }
        Transformation other = (Transformation) obj;
        return Objects.equals(stepToApplyAsString(), other.stepToApplyAsString())
                && Objects.equals(transformationFunction(), other.transformationFunction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Transformation").add("StepToApply", stepToApplyAsString())
                .add("TransformationFunction", transformationFunction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepToApply":
            return Optional.ofNullable(clazz.cast(stepToApplyAsString()));
        case "transformationFunction":
            return Optional.ofNullable(clazz.cast(transformationFunction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepToApply", STEP_TO_APPLY_FIELD);
        map.put("transformationFunction", TRANSFORMATION_FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Transformation, T> g) {
        return obj -> g.apply((Transformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Transformation> {
        /**
         * <p>
         * When the service applies the transformation.
         * </p>
         * 
         * @param stepToApply
         *        When the service applies the transformation.
         * @see StepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepType
         */
        Builder stepToApply(String stepToApply);

        /**
         * <p>
         * When the service applies the transformation.
         * </p>
         * 
         * @param stepToApply
         *        When the service applies the transformation.
         * @see StepType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepType
         */
        Builder stepToApply(StepType stepToApply);

        /**
         * <p>
         * A Lambda function that processes documents.
         * </p>
         * 
         * @param transformationFunction
         *        A Lambda function that processes documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transformationFunction(TransformationFunction transformationFunction);

        /**
         * <p>
         * A Lambda function that processes documents.
         * </p>
         * This is a convenience method that creates an instance of the {@link TransformationFunction.Builder} avoiding
         * the need to create one manually via {@link TransformationFunction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TransformationFunction.Builder#build()} is called immediately and
         * its result is passed to {@link #transformationFunction(TransformationFunction)}.
         * 
         * @param transformationFunction
         *        a consumer that will call methods on {@link TransformationFunction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transformationFunction(TransformationFunction)
         */
        default Builder transformationFunction(Consumer<TransformationFunction.Builder> transformationFunction) {
            return transformationFunction(TransformationFunction.builder().applyMutation(transformationFunction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stepToApply;

        private TransformationFunction transformationFunction;

        private BuilderImpl() {
        }

        private BuilderImpl(Transformation model) {
            stepToApply(model.stepToApply);
            transformationFunction(model.transformationFunction);
        }

        public final String getStepToApply() {
            return stepToApply;
        }

        public final void setStepToApply(String stepToApply) {
            this.stepToApply = stepToApply;
        }

        @Override
        public final Builder stepToApply(String stepToApply) {
            this.stepToApply = stepToApply;
            return this;
        }

        @Override
        public final Builder stepToApply(StepType stepToApply) {
            this.stepToApply(stepToApply == null ? null : stepToApply.toString());
            return this;
        }

        public final TransformationFunction.Builder getTransformationFunction() {
            return transformationFunction != null ? transformationFunction.toBuilder() : null;
        }

        public final void setTransformationFunction(TransformationFunction.BuilderImpl transformationFunction) {
            this.transformationFunction = transformationFunction != null ? transformationFunction.build() : null;
        }

        @Override
        public final Builder transformationFunction(TransformationFunction transformationFunction) {
            this.transformationFunction = transformationFunction;
            return this;
        }

        @Override
        public Transformation build() {
            return new Transformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
