/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the Managed Cluster configuration of the knowledge base in Amazon OpenSearch Service. For more
 * information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/knowledge-base-setup-osm.html">Create
 * a vector index in OpenSearch Managed Cluster</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenSearchManagedClusterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenSearchManagedClusterConfiguration.Builder, OpenSearchManagedClusterConfiguration> {
    private static final SdkField<String> DOMAIN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainArn").getter(getter(OpenSearchManagedClusterConfiguration::domainArn))
            .setter(setter(Builder::domainArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainArn").build()).build();

    private static final SdkField<String> DOMAIN_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainEndpoint").getter(getter(OpenSearchManagedClusterConfiguration::domainEndpoint))
            .setter(setter(Builder::domainEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainEndpoint").build()).build();

    private static final SdkField<OpenSearchManagedClusterFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<OpenSearchManagedClusterFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(OpenSearchManagedClusterConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(OpenSearchManagedClusterFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorIndexName").getter(getter(OpenSearchManagedClusterConfiguration::vectorIndexName))
            .setter(setter(Builder::vectorIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ARN_FIELD,
            DOMAIN_ENDPOINT_FIELD, FIELD_MAPPING_FIELD, VECTOR_INDEX_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainArn;

    private final String domainEndpoint;

    private final OpenSearchManagedClusterFieldMapping fieldMapping;

    private final String vectorIndexName;

    private OpenSearchManagedClusterConfiguration(BuilderImpl builder) {
        this.domainArn = builder.domainArn;
        this.domainEndpoint = builder.domainEndpoint;
        this.fieldMapping = builder.fieldMapping;
        this.vectorIndexName = builder.vectorIndexName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the OpenSearch domain.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the OpenSearch domain.
     */
    public final String domainArn() {
        return domainArn;
    }

    /**
     * <p>
     * The endpoint URL the OpenSearch domain.
     * </p>
     * 
     * @return The endpoint URL the OpenSearch domain.
     */
    public final String domainEndpoint() {
        return domainEndpoint;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final OpenSearchManagedClusterFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The name of the vector store.
     * </p>
     * 
     * @return The name of the vector store.
     */
    public final String vectorIndexName() {
        return vectorIndexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainArn());
        hashCode = 31 * hashCode + Objects.hashCode(domainEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIndexName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenSearchManagedClusterConfiguration)) {
            return false;
        }
        OpenSearchManagedClusterConfiguration other = (OpenSearchManagedClusterConfiguration) obj;
        return Objects.equals(domainArn(), other.domainArn()) && Objects.equals(domainEndpoint(), other.domainEndpoint())
                && Objects.equals(fieldMapping(), other.fieldMapping())
                && Objects.equals(vectorIndexName(), other.vectorIndexName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenSearchManagedClusterConfiguration").add("DomainArn", domainArn())
                .add("DomainEndpoint", domainEndpoint()).add("FieldMapping", fieldMapping())
                .add("VectorIndexName", vectorIndexName() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainArn":
            return Optional.ofNullable(clazz.cast(domainArn()));
        case "domainEndpoint":
            return Optional.ofNullable(clazz.cast(domainEndpoint()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "vectorIndexName":
            return Optional.ofNullable(clazz.cast(vectorIndexName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("domainArn", DOMAIN_ARN_FIELD);
        map.put("domainEndpoint", DOMAIN_ENDPOINT_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpenSearchManagedClusterConfiguration, T> g) {
        return obj -> g.apply((OpenSearchManagedClusterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenSearchManagedClusterConfiguration> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the OpenSearch domain.
         * </p>
         * 
         * @param domainArn
         *        The Amazon Resource Name (ARN) of the OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainArn(String domainArn);

        /**
         * <p>
         * The endpoint URL the OpenSearch domain.
         * </p>
         * 
         * @param domainEndpoint
         *        The endpoint URL the OpenSearch domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainEndpoint(String domainEndpoint);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(OpenSearchManagedClusterFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OpenSearchManagedClusterFieldMapping.Builder} avoiding the need to create one manually via
         * {@link OpenSearchManagedClusterFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpenSearchManagedClusterFieldMapping.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldMapping(OpenSearchManagedClusterFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link OpenSearchManagedClusterFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(OpenSearchManagedClusterFieldMapping)
         */
        default Builder fieldMapping(Consumer<OpenSearchManagedClusterFieldMapping.Builder> fieldMapping) {
            return fieldMapping(OpenSearchManagedClusterFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The name of the vector store.
         * </p>
         * 
         * @param vectorIndexName
         *        The name of the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIndexName(String vectorIndexName);
    }

    static final class BuilderImpl implements Builder {
        private String domainArn;

        private String domainEndpoint;

        private OpenSearchManagedClusterFieldMapping fieldMapping;

        private String vectorIndexName;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenSearchManagedClusterConfiguration model) {
            domainArn(model.domainArn);
            domainEndpoint(model.domainEndpoint);
            fieldMapping(model.fieldMapping);
            vectorIndexName(model.vectorIndexName);
        }

        public final String getDomainArn() {
            return domainArn;
        }

        public final void setDomainArn(String domainArn) {
            this.domainArn = domainArn;
        }

        @Override
        public final Builder domainArn(String domainArn) {
            this.domainArn = domainArn;
            return this;
        }

        public final String getDomainEndpoint() {
            return domainEndpoint;
        }

        public final void setDomainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
        }

        @Override
        public final Builder domainEndpoint(String domainEndpoint) {
            this.domainEndpoint = domainEndpoint;
            return this;
        }

        public final OpenSearchManagedClusterFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(OpenSearchManagedClusterFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(OpenSearchManagedClusterFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getVectorIndexName() {
            return vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        @Override
        public OpenSearchManagedClusterConfiguration build() {
            return new OpenSearchManagedClusterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
