/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the storage configuration of the knowledge base in MongoDB Atlas.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MongoDbAtlasConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MongoDbAtlasConfiguration.Builder, MongoDbAtlasConfiguration> {
    private static final SdkField<String> COLLECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("collectionName").getter(getter(MongoDbAtlasConfiguration::collectionName))
            .setter(setter(Builder::collectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionName").build()).build();

    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialsSecretArn").getter(getter(MongoDbAtlasConfiguration::credentialsSecretArn))
            .setter(setter(Builder::credentialsSecretArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build())
            .build();

    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("databaseName").getter(getter(MongoDbAtlasConfiguration::databaseName))
            .setter(setter(Builder::databaseName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()).build();

    private static final SdkField<String> ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpoint").getter(getter(MongoDbAtlasConfiguration::endpoint)).setter(setter(Builder::endpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoint").build()).build();

    private static final SdkField<String> ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("endpointServiceName").getter(getter(MongoDbAtlasConfiguration::endpointServiceName))
            .setter(setter(Builder::endpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpointServiceName").build())
            .build();

    private static final SdkField<MongoDbAtlasFieldMapping> FIELD_MAPPING_FIELD = SdkField
            .<MongoDbAtlasFieldMapping> builder(MarshallingType.SDK_POJO).memberName("fieldMapping")
            .getter(getter(MongoDbAtlasConfiguration::fieldMapping)).setter(setter(Builder::fieldMapping))
            .constructor(MongoDbAtlasFieldMapping::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()).build();

    private static final SdkField<String> TEXT_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textIndexName").getter(getter(MongoDbAtlasConfiguration::textIndexName))
            .setter(setter(Builder::textIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textIndexName").build()).build();

    private static final SdkField<String> VECTOR_INDEX_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vectorIndexName").getter(getter(MongoDbAtlasConfiguration::vectorIndexName))
            .setter(setter(Builder::vectorIndexName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vectorIndexName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_NAME_FIELD,
            CREDENTIALS_SECRET_ARN_FIELD, DATABASE_NAME_FIELD, ENDPOINT_FIELD, ENDPOINT_SERVICE_NAME_FIELD, FIELD_MAPPING_FIELD,
            TEXT_INDEX_NAME_FIELD, VECTOR_INDEX_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String collectionName;

    private final String credentialsSecretArn;

    private final String databaseName;

    private final String endpoint;

    private final String endpointServiceName;

    private final MongoDbAtlasFieldMapping fieldMapping;

    private final String textIndexName;

    private final String vectorIndexName;

    private MongoDbAtlasConfiguration(BuilderImpl builder) {
        this.collectionName = builder.collectionName;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.databaseName = builder.databaseName;
        this.endpoint = builder.endpoint;
        this.endpointServiceName = builder.endpointServiceName;
        this.fieldMapping = builder.fieldMapping;
        this.textIndexName = builder.textIndexName;
        this.vectorIndexName = builder.vectorIndexName;
    }

    /**
     * <p>
     * The collection name of the knowledge base in MongoDB Atlas.
     * </p>
     * 
     * @return The collection name of the knowledge base in MongoDB Atlas.
     */
    public final String collectionName() {
        return collectionName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that contains user credentials
     * for your MongoDB Atlas cluster.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that contains user
     *         credentials for your MongoDB Atlas cluster.
     */
    public final String credentialsSecretArn() {
        return credentialsSecretArn;
    }

    /**
     * <p>
     * The database name in your MongoDB Atlas cluster for your knowledge base.
     * </p>
     * 
     * @return The database name in your MongoDB Atlas cluster for your knowledge base.
     */
    public final String databaseName() {
        return databaseName;
    }

    /**
     * <p>
     * The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
     * </p>
     * 
     * @return The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
     */
    public final String endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
     * </p>
     * 
     * @return The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
     */
    public final String endpointServiceName() {
        return endpointServiceName;
    }

    /**
     * <p>
     * Contains the names of the fields to which to map information about the vector store.
     * </p>
     * 
     * @return Contains the names of the fields to which to map information about the vector store.
     */
    public final MongoDbAtlasFieldMapping fieldMapping() {
        return fieldMapping;
    }

    /**
     * <p>
     * The name of the text search index in the MongoDB collection. This is required for using the hybrid search
     * feature.
     * </p>
     * 
     * @return The name of the text search index in the MongoDB collection. This is required for using the hybrid search
     *         feature.
     */
    public final String textIndexName() {
        return textIndexName;
    }

    /**
     * <p>
     * The name of the MongoDB Atlas vector search index.
     * </p>
     * 
     * @return The name of the MongoDB Atlas vector search index.
     */
    public final String vectorIndexName() {
        return vectorIndexName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(collectionName());
        hashCode = 31 * hashCode + Objects.hashCode(credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(endpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(textIndexName());
        hashCode = 31 * hashCode + Objects.hashCode(vectorIndexName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MongoDbAtlasConfiguration)) {
            return false;
        }
        MongoDbAtlasConfiguration other = (MongoDbAtlasConfiguration) obj;
        return Objects.equals(collectionName(), other.collectionName())
                && Objects.equals(credentialsSecretArn(), other.credentialsSecretArn())
                && Objects.equals(databaseName(), other.databaseName()) && Objects.equals(endpoint(), other.endpoint())
                && Objects.equals(endpointServiceName(), other.endpointServiceName())
                && Objects.equals(fieldMapping(), other.fieldMapping()) && Objects.equals(textIndexName(), other.textIndexName())
                && Objects.equals(vectorIndexName(), other.vectorIndexName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MongoDbAtlasConfiguration").add("CollectionName", collectionName())
                .add("CredentialsSecretArn", credentialsSecretArn()).add("DatabaseName", databaseName())
                .add("Endpoint", endpoint()).add("EndpointServiceName", endpointServiceName())
                .add("FieldMapping", fieldMapping()).add("TextIndexName", textIndexName())
                .add("VectorIndexName", vectorIndexName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectionName":
            return Optional.ofNullable(clazz.cast(collectionName()));
        case "credentialsSecretArn":
            return Optional.ofNullable(clazz.cast(credentialsSecretArn()));
        case "databaseName":
            return Optional.ofNullable(clazz.cast(databaseName()));
        case "endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "endpointServiceName":
            return Optional.ofNullable(clazz.cast(endpointServiceName()));
        case "fieldMapping":
            return Optional.ofNullable(clazz.cast(fieldMapping()));
        case "textIndexName":
            return Optional.ofNullable(clazz.cast(textIndexName()));
        case "vectorIndexName":
            return Optional.ofNullable(clazz.cast(vectorIndexName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collectionName", COLLECTION_NAME_FIELD);
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("endpoint", ENDPOINT_FIELD);
        map.put("endpointServiceName", ENDPOINT_SERVICE_NAME_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("textIndexName", TEXT_INDEX_NAME_FIELD);
        map.put("vectorIndexName", VECTOR_INDEX_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MongoDbAtlasConfiguration, T> g) {
        return obj -> g.apply((MongoDbAtlasConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MongoDbAtlasConfiguration> {
        /**
         * <p>
         * The collection name of the knowledge base in MongoDB Atlas.
         * </p>
         * 
         * @param collectionName
         *        The collection name of the knowledge base in MongoDB Atlas.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionName(String collectionName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that contains user
         * credentials for your MongoDB Atlas cluster.
         * </p>
         * 
         * @param credentialsSecretArn
         *        The Amazon Resource Name (ARN) of the secret that you created in Secrets Manager that contains user
         *        credentials for your MongoDB Atlas cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialsSecretArn(String credentialsSecretArn);

        /**
         * <p>
         * The database name in your MongoDB Atlas cluster for your knowledge base.
         * </p>
         * 
         * @param databaseName
         *        The database name in your MongoDB Atlas cluster for your knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);

        /**
         * <p>
         * The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
         * </p>
         * 
         * @param endpoint
         *        The endpoint URL of your MongoDB Atlas cluster for your knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(String endpoint);

        /**
         * <p>
         * The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
         * </p>
         * 
         * @param endpointServiceName
         *        The name of the VPC endpoint service in your account that is connected to your MongoDB Atlas cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpointServiceName(String endpointServiceName);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * 
         * @param fieldMapping
         *        Contains the names of the fields to which to map information about the vector store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMapping(MongoDbAtlasFieldMapping fieldMapping);

        /**
         * <p>
         * Contains the names of the fields to which to map information about the vector store.
         * </p>
         * This is a convenience method that creates an instance of the {@link MongoDbAtlasFieldMapping.Builder}
         * avoiding the need to create one manually via {@link MongoDbAtlasFieldMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MongoDbAtlasFieldMapping.Builder#build()} is called immediately
         * and its result is passed to {@link #fieldMapping(MongoDbAtlasFieldMapping)}.
         * 
         * @param fieldMapping
         *        a consumer that will call methods on {@link MongoDbAtlasFieldMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldMapping(MongoDbAtlasFieldMapping)
         */
        default Builder fieldMapping(Consumer<MongoDbAtlasFieldMapping.Builder> fieldMapping) {
            return fieldMapping(MongoDbAtlasFieldMapping.builder().applyMutation(fieldMapping).build());
        }

        /**
         * <p>
         * The name of the text search index in the MongoDB collection. This is required for using the hybrid search
         * feature.
         * </p>
         * 
         * @param textIndexName
         *        The name of the text search index in the MongoDB collection. This is required for using the hybrid
         *        search feature.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textIndexName(String textIndexName);

        /**
         * <p>
         * The name of the MongoDB Atlas vector search index.
         * </p>
         * 
         * @param vectorIndexName
         *        The name of the MongoDB Atlas vector search index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vectorIndexName(String vectorIndexName);
    }

    static final class BuilderImpl implements Builder {
        private String collectionName;

        private String credentialsSecretArn;

        private String databaseName;

        private String endpoint;

        private String endpointServiceName;

        private MongoDbAtlasFieldMapping fieldMapping;

        private String textIndexName;

        private String vectorIndexName;

        private BuilderImpl() {
        }

        private BuilderImpl(MongoDbAtlasConfiguration model) {
            collectionName(model.collectionName);
            credentialsSecretArn(model.credentialsSecretArn);
            databaseName(model.databaseName);
            endpoint(model.endpoint);
            endpointServiceName(model.endpointServiceName);
            fieldMapping(model.fieldMapping);
            textIndexName(model.textIndexName);
            vectorIndexName(model.vectorIndexName);
        }

        public final String getCollectionName() {
            return collectionName;
        }

        public final void setCollectionName(String collectionName) {
            this.collectionName = collectionName;
        }

        @Override
        public final Builder collectionName(String collectionName) {
            this.collectionName = collectionName;
            return this;
        }

        public final String getCredentialsSecretArn() {
            return credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getEndpoint() {
            return endpoint;
        }

        public final void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public final Builder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getEndpointServiceName() {
            return endpointServiceName;
        }

        public final void setEndpointServiceName(String endpointServiceName) {
            this.endpointServiceName = endpointServiceName;
        }

        @Override
        public final Builder endpointServiceName(String endpointServiceName) {
            this.endpointServiceName = endpointServiceName;
            return this;
        }

        public final MongoDbAtlasFieldMapping.Builder getFieldMapping() {
            return fieldMapping != null ? fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(MongoDbAtlasFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(MongoDbAtlasFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getTextIndexName() {
            return textIndexName;
        }

        public final void setTextIndexName(String textIndexName) {
            this.textIndexName = textIndexName;
        }

        @Override
        public final Builder textIndexName(String textIndexName) {
            this.textIndexName = textIndexName;
            return this;
        }

        public final String getVectorIndexName() {
            return vectorIndexName;
        }

        public final void setVectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
        }

        @Override
        public final Builder vectorIndexName(String vectorIndexName) {
            this.vectorIndexName = vectorIndexName;
            return this;
        }

        @Override
        public MongoDbAtlasConfiguration build() {
            return new MongoDbAtlasConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
