/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a document to ingest into a knowledge base and metadata to associate with it.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseDocument.Builder, KnowledgeBaseDocument> {
    private static final SdkField<DocumentContent> CONTENT_FIELD = SdkField.<DocumentContent> builder(MarshallingType.SDK_POJO)
            .memberName("content").getter(getter(KnowledgeBaseDocument::content)).setter(setter(Builder::content))
            .constructor(DocumentContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<DocumentMetadata> METADATA_FIELD = SdkField
            .<DocumentMetadata> builder(MarshallingType.SDK_POJO).memberName("metadata")
            .getter(getter(KnowledgeBaseDocument::metadata)).setter(setter(Builder::metadata))
            .constructor(DocumentMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CONTENT_FIELD, METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final DocumentContent content;

    private final DocumentMetadata metadata;

    private KnowledgeBaseDocument(BuilderImpl builder) {
        this.content = builder.content;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * Contains the content of the document.
     * </p>
     * 
     * @return Contains the content of the document.
     */
    public final DocumentContent content() {
        return content;
    }

    /**
     * <p>
     * Contains the metadata to associate with the document.
     * </p>
     * 
     * @return Contains the metadata to associate with the document.
     */
    public final DocumentMetadata metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseDocument)) {
            return false;
        }
        KnowledgeBaseDocument other = (KnowledgeBaseDocument) obj;
        return Objects.equals(content(), other.content()) && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseDocument").add("Content", content()).add("Metadata", metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseDocument, T> g) {
        return obj -> g.apply((KnowledgeBaseDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseDocument> {
        /**
         * <p>
         * Contains the content of the document.
         * </p>
         * 
         * @param content
         *        Contains the content of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(DocumentContent content);

        /**
         * <p>
         * Contains the content of the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentContent.Builder} avoiding the
         * need to create one manually via {@link DocumentContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentContent.Builder#build()} is called immediately and its
         * result is passed to {@link #content(DocumentContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link DocumentContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(DocumentContent)
         */
        default Builder content(Consumer<DocumentContent.Builder> content) {
            return content(DocumentContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * Contains the metadata to associate with the document.
         * </p>
         * 
         * @param metadata
         *        Contains the metadata to associate with the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(DocumentMetadata metadata);

        /**
         * <p>
         * Contains the metadata to associate with the document.
         * </p>
         * This is a convenience method that creates an instance of the {@link DocumentMetadata.Builder} avoiding the
         * need to create one manually via {@link DocumentMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DocumentMetadata.Builder#build()} is called immediately and its
         * result is passed to {@link #metadata(DocumentMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link DocumentMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(DocumentMetadata)
         */
        default Builder metadata(Consumer<DocumentMetadata.Builder> metadata) {
            return metadata(DocumentMetadata.builder().applyMutation(metadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DocumentContent content;

        private DocumentMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseDocument model) {
            content(model.content);
            metadata(model.metadata);
        }

        public final DocumentContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(DocumentContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(DocumentContent content) {
            this.content = content;
            return this;
        }

        public final DocumentMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        public final void setMetadata(DocumentMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(DocumentMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        @Override
        public KnowledgeBaseDocument build() {
            return new KnowledgeBaseDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
