/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.RdsFieldMapping;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsConfiguration> {
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(RdsConfiguration.getter(RdsConfiguration::credentialsSecretArn)).setter(RdsConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(RdsConfiguration.getter(RdsConfiguration::databaseName)).setter(RdsConfiguration.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<RdsFieldMapping> FIELD_MAPPING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fieldMapping").getter(RdsConfiguration.getter(RdsConfiguration::fieldMapping)).setter(RdsConfiguration.setter(Builder::fieldMapping)).constructor(RdsFieldMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldMapping").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(RdsConfiguration.getter(RdsConfiguration::resourceArn)).setter(RdsConfiguration.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tableName").getter(RdsConfiguration.getter(RdsConfiguration::tableName)).setter(RdsConfiguration.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tableName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_SECRET_ARN_FIELD, DATABASE_NAME_FIELD, FIELD_MAPPING_FIELD, RESOURCE_ARN_FIELD, TABLE_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RdsConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String credentialsSecretArn;
    private final String databaseName;
    private final RdsFieldMapping fieldMapping;
    private final String resourceArn;
    private final String tableName;

    private RdsConfiguration(BuilderImpl builder) {
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.databaseName = builder.databaseName;
        this.fieldMapping = builder.fieldMapping;
        this.resourceArn = builder.resourceArn;
        this.tableName = builder.tableName;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final RdsFieldMapping fieldMapping() {
        return this.fieldMapping;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String tableName() {
        return this.tableName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldMapping());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsConfiguration)) {
            return false;
        }
        RdsConfiguration other = (RdsConfiguration)obj;
        return Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.fieldMapping(), other.fieldMapping()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.tableName(), other.tableName());
    }

    public final String toString() {
        return ToString.builder((String)"RdsConfiguration").add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).add("DatabaseName", (Object)this.databaseName()).add("FieldMapping", (Object)this.fieldMapping()).add("ResourceArn", (Object)this.resourceArn()).add("TableName", (Object)this.tableName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "fieldMapping": {
                return Optional.ofNullable(clazz.cast(this.fieldMapping()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "tableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentialsSecretArn", CREDENTIALS_SECRET_ARN_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("fieldMapping", FIELD_MAPPING_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("tableName", TABLE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RdsConfiguration, T> g) {
        return obj -> g.apply((RdsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String credentialsSecretArn;
        private String databaseName;
        private RdsFieldMapping fieldMapping;
        private String resourceArn;
        private String tableName;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsConfiguration model) {
            this.credentialsSecretArn(model.credentialsSecretArn);
            this.databaseName(model.databaseName);
            this.fieldMapping(model.fieldMapping);
            this.resourceArn(model.resourceArn);
            this.tableName(model.tableName);
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final RdsFieldMapping.Builder getFieldMapping() {
            return this.fieldMapping != null ? this.fieldMapping.toBuilder() : null;
        }

        public final void setFieldMapping(RdsFieldMapping.BuilderImpl fieldMapping) {
            this.fieldMapping = fieldMapping != null ? fieldMapping.build() : null;
        }

        @Override
        public final Builder fieldMapping(RdsFieldMapping fieldMapping) {
            this.fieldMapping = fieldMapping;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public RdsConfiguration build() {
            return new RdsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsConfiguration> {
        public Builder credentialsSecretArn(String var1);

        public Builder databaseName(String var1);

        public Builder fieldMapping(RdsFieldMapping var1);

        default public Builder fieldMapping(Consumer<RdsFieldMapping.Builder> fieldMapping) {
            return this.fieldMapping((RdsFieldMapping)((RdsFieldMapping.Builder)RdsFieldMapping.builder().applyMutation(fieldMapping)).build());
        }

        public Builder resourceArn(String var1);

        public Builder tableName(String var1);
    }
}

