/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.services.bedrockagent.model.DataSourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteDataSourceResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, DeleteDataSourceResponse> {
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(DeleteDataSourceResponse.getter(DeleteDataSourceResponse::dataSourceId)).setter(DeleteDataSourceResponse.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(DeleteDataSourceResponse.getter(DeleteDataSourceResponse::knowledgeBaseId)).setter(DeleteDataSourceResponse.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteDataSourceResponse.getter(DeleteDataSourceResponse::statusAsString)).setter(DeleteDataSourceResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SOURCE_ID_FIELD, KNOWLEDGE_BASE_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("dataSourceId", DATA_SOURCE_ID_FIELD);
            this.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private final String dataSourceId;
    private final String knowledgeBaseId;
    private final String status;

    private DeleteDataSourceResponse(BuilderImpl builder) {
        super(builder);
        this.dataSourceId = builder.dataSourceId;
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.status = builder.status;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDataSourceResponse)) {
            return false;
        }
        DeleteDataSourceResponse other = (DeleteDataSourceResponse)((Object)obj);
        return Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteDataSourceResponse").add("DataSourceId", (Object)this.dataSourceId()).add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDataSourceResponse, T> g) {
        return obj -> g.apply((DeleteDataSourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String dataSourceId;
        private String knowledgeBaseId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDataSourceResponse model) {
            super(model);
            this.dataSourceId(model.dataSourceId);
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.status(model.status);
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteDataSourceResponse build() {
            return new DeleteDataSourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteDataSourceResponse> {
        public Builder dataSourceId(String var1);

        public Builder knowledgeBaseId(String var1);

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);
    }
}

