/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.AgentStatus;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteAgentVersionResponse
extends BedrockAgentResponse
implements ToCopyableBuilder<Builder, DeleteAgentVersionResponse> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(DeleteAgentVersionResponse.getter(DeleteAgentVersionResponse::agentId)).setter(DeleteAgentVersionResponse.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> AGENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentStatus").getter(DeleteAgentVersionResponse.getter(DeleteAgentVersionResponse::agentStatusAsString)).setter(DeleteAgentVersionResponse.setter(Builder::agentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentStatus").build()}).build();
    private static final SdkField<String> AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentVersion").getter(DeleteAgentVersionResponse.getter(DeleteAgentVersionResponse::agentVersion)).setter(DeleteAgentVersionResponse.setter(Builder::agentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD, AGENT_STATUS_FIELD, AGENT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("agentId", AGENT_ID_FIELD);
            this.put("agentStatus", AGENT_STATUS_FIELD);
            this.put("agentVersion", AGENT_VERSION_FIELD);
        }
    });
    private final String agentId;
    private final String agentStatus;
    private final String agentVersion;

    private DeleteAgentVersionResponse(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentStatus = builder.agentStatus;
        this.agentVersion = builder.agentVersion;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final AgentStatus agentStatus() {
        return AgentStatus.fromValue(this.agentStatus);
    }

    public final String agentStatusAsString() {
        return this.agentStatus;
    }

    public final String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAgentVersionResponse)) {
            return false;
        }
        DeleteAgentVersionResponse other = (DeleteAgentVersionResponse)((Object)obj);
        return Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.agentStatusAsString(), other.agentStatusAsString()) && Objects.equals(this.agentVersion(), other.agentVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteAgentVersionResponse").add("AgentId", (Object)this.agentId()).add("AgentStatus", (Object)this.agentStatusAsString()).add("AgentVersion", (Object)this.agentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "agentStatus": {
                return Optional.ofNullable(clazz.cast(this.agentStatusAsString()));
            }
            case "agentVersion": {
                return Optional.ofNullable(clazz.cast(this.agentVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAgentVersionResponse, T> g) {
        return obj -> g.apply((DeleteAgentVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentResponse.BuilderImpl
    implements Builder {
        private String agentId;
        private String agentStatus;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAgentVersionResponse model) {
            super(model);
            this.agentId(model.agentId);
            this.agentStatus(model.agentStatus);
            this.agentVersion(model.agentVersion);
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentStatus() {
            return this.agentStatus;
        }

        public final void setAgentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
        }

        @Override
        public final Builder agentStatus(String agentStatus) {
            this.agentStatus = agentStatus;
            return this;
        }

        @Override
        public final Builder agentStatus(AgentStatus agentStatus) {
            this.agentStatus(agentStatus == null ? null : agentStatus.toString());
            return this;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        @Override
        public DeleteAgentVersionResponse build() {
            return new DeleteAgentVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteAgentVersionResponse> {
        public Builder agentId(String var1);

        public Builder agentStatus(String var1);

        public Builder agentStatus(AgentStatus var1);

        public Builder agentVersion(String var1);
    }
}

