/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SalesforceAuthType {
    OAUTH2_CLIENT_CREDENTIALS("OAUTH2_CLIENT_CREDENTIALS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SalesforceAuthType> VALUE_MAP;
    private final String value;

    private SalesforceAuthType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SalesforceAuthType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SalesforceAuthType> knownValues() {
        EnumSet<SalesforceAuthType> knownValues = EnumSet.allOf(SalesforceAuthType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SalesforceAuthType.class, SalesforceAuthType::toString);
    }
}

