/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum KnowledgeBaseStorageType {
    OPENSEARCH_SERVERLESS("OPENSEARCH_SERVERLESS"),
    PINECONE("PINECONE"),
    REDIS_ENTERPRISE_CLOUD("REDIS_ENTERPRISE_CLOUD"),
    RDS("RDS"),
    MONGO_DB_ATLAS("MONGO_DB_ATLAS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, KnowledgeBaseStorageType> VALUE_MAP;
    private final String value;

    private KnowledgeBaseStorageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static KnowledgeBaseStorageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<KnowledgeBaseStorageType> knownValues() {
        EnumSet<KnowledgeBaseStorageType> knownValues = EnumSet.allOf(KnowledgeBaseStorageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(KnowledgeBaseStorageType.class, KnowledgeBaseStorageType::toString);
    }
}

