/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagent.model.SalesforceAuthType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SalesforceSourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SalesforceSourceConfiguration> {
    private static final SdkField<String> AUTH_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authType").getter(SalesforceSourceConfiguration.getter(SalesforceSourceConfiguration::authTypeAsString)).setter(SalesforceSourceConfiguration.setter(Builder::authType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authType").build()}).build();
    private static final SdkField<String> CREDENTIALS_SECRET_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialsSecretArn").getter(SalesforceSourceConfiguration.getter(SalesforceSourceConfiguration::credentialsSecretArn)).setter(SalesforceSourceConfiguration.setter(Builder::credentialsSecretArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialsSecretArn").build()}).build();
    private static final SdkField<String> HOST_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostUrl").getter(SalesforceSourceConfiguration.getter(SalesforceSourceConfiguration::hostUrl)).setter(SalesforceSourceConfiguration.setter(Builder::hostUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTH_TYPE_FIELD, CREDENTIALS_SECRET_ARN_FIELD, HOST_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authType;
    private final String credentialsSecretArn;
    private final String hostUrl;

    private SalesforceSourceConfiguration(BuilderImpl builder) {
        this.authType = builder.authType;
        this.credentialsSecretArn = builder.credentialsSecretArn;
        this.hostUrl = builder.hostUrl;
    }

    public final SalesforceAuthType authType() {
        return SalesforceAuthType.fromValue(this.authType);
    }

    public final String authTypeAsString() {
        return this.authType;
    }

    public final String credentialsSecretArn() {
        return this.credentialsSecretArn;
    }

    public final String hostUrl() {
        return this.hostUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialsSecretArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SalesforceSourceConfiguration)) {
            return false;
        }
        SalesforceSourceConfiguration other = (SalesforceSourceConfiguration)obj;
        return Objects.equals(this.authTypeAsString(), other.authTypeAsString()) && Objects.equals(this.credentialsSecretArn(), other.credentialsSecretArn()) && Objects.equals(this.hostUrl(), other.hostUrl());
    }

    public final String toString() {
        return ToString.builder((String)"SalesforceSourceConfiguration").add("AuthType", (Object)this.authTypeAsString()).add("CredentialsSecretArn", (Object)this.credentialsSecretArn()).add("HostUrl", (Object)this.hostUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authType": {
                return Optional.ofNullable(clazz.cast(this.authTypeAsString()));
            }
            case "credentialsSecretArn": {
                return Optional.ofNullable(clazz.cast(this.credentialsSecretArn()));
            }
            case "hostUrl": {
                return Optional.ofNullable(clazz.cast(this.hostUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SalesforceSourceConfiguration, T> g) {
        return obj -> g.apply((SalesforceSourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authType;
        private String credentialsSecretArn;
        private String hostUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SalesforceSourceConfiguration model) {
            this.authType(model.authType);
            this.credentialsSecretArn(model.credentialsSecretArn);
            this.hostUrl(model.hostUrl);
        }

        public final String getAuthType() {
            return this.authType;
        }

        public final void setAuthType(String authType) {
            this.authType = authType;
        }

        @Override
        public final Builder authType(String authType) {
            this.authType = authType;
            return this;
        }

        @Override
        public final Builder authType(SalesforceAuthType authType) {
            this.authType(authType == null ? null : authType.toString());
            return this;
        }

        public final String getCredentialsSecretArn() {
            return this.credentialsSecretArn;
        }

        public final void setCredentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
        }

        @Override
        public final Builder credentialsSecretArn(String credentialsSecretArn) {
            this.credentialsSecretArn = credentialsSecretArn;
            return this;
        }

        public final String getHostUrl() {
            return this.hostUrl;
        }

        public final void setHostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
        }

        @Override
        public final Builder hostUrl(String hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public SalesforceSourceConfiguration build() {
            return new SalesforceSourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SalesforceSourceConfiguration> {
        public Builder authType(String var1);

        public Builder authType(SalesforceAuthType var1);

        public Builder credentialsSecretArn(String var1);

        public Builder hostUrl(String var1);
    }
}

