/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagent.model.BedrockAgentRequest;
import software.amazon.awssdk.services.bedrockagent.model.KnowledgeBaseConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.StorageConfiguration;
import software.amazon.awssdk.services.bedrockagent.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateKnowledgeBaseRequest
extends BedrockAgentRequest
implements ToCopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::clientToken)).setter(CreateKnowledgeBaseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::description)).setter(CreateKnowledgeBaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<KnowledgeBaseConfiguration> KNOWLEDGE_BASE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::knowledgeBaseConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::knowledgeBaseConfiguration)).constructor(KnowledgeBaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseConfiguration").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::name)).setter(CreateKnowledgeBaseRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::roleArn)).setter(CreateKnowledgeBaseRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<StorageConfiguration> STORAGE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storageConfiguration").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::storageConfiguration)).setter(CreateKnowledgeBaseRequest.setter(Builder::storageConfiguration)).constructor(StorageConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateKnowledgeBaseRequest.getter(CreateKnowledgeBaseRequest::tags)).setter(CreateKnowledgeBaseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, KNOWLEDGE_BASE_CONFIGURATION_FIELD, NAME_FIELD, ROLE_ARN_FIELD, STORAGE_CONFIGURATION_FIELD, TAGS_FIELD));
    private final String clientToken;
    private final String description;
    private final KnowledgeBaseConfiguration knowledgeBaseConfiguration;
    private final String name;
    private final String roleArn;
    private final StorageConfiguration storageConfiguration;
    private final Map<String, String> tags;

    private CreateKnowledgeBaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.knowledgeBaseConfiguration = builder.knowledgeBaseConfiguration;
        this.name = builder.name;
        this.roleArn = builder.roleArn;
        this.storageConfiguration = builder.storageConfiguration;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final KnowledgeBaseConfiguration knowledgeBaseConfiguration() {
        return this.knowledgeBaseConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final StorageConfiguration storageConfiguration() {
        return this.storageConfiguration;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateKnowledgeBaseRequest)) {
            return false;
        }
        CreateKnowledgeBaseRequest other = (CreateKnowledgeBaseRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.knowledgeBaseConfiguration(), other.knowledgeBaseConfiguration()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.storageConfiguration(), other.storageConfiguration()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateKnowledgeBaseRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)this.description()).add("KnowledgeBaseConfiguration", (Object)this.knowledgeBaseConfiguration()).add("Name", (Object)this.name()).add("RoleArn", (Object)this.roleArn()).add("StorageConfiguration", (Object)this.storageConfiguration()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "knowledgeBaseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseConfiguration()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "storageConfiguration": {
                return Optional.ofNullable(clazz.cast(this.storageConfiguration()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateKnowledgeBaseRequest, T> g) {
        return obj -> g.apply((CreateKnowledgeBaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private KnowledgeBaseConfiguration knowledgeBaseConfiguration;
        private String name;
        private String roleArn;
        private StorageConfiguration storageConfiguration;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateKnowledgeBaseRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.knowledgeBaseConfiguration(model.knowledgeBaseConfiguration);
            this.name(model.name);
            this.roleArn(model.roleArn);
            this.storageConfiguration(model.storageConfiguration);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final KnowledgeBaseConfiguration.Builder getKnowledgeBaseConfiguration() {
            return this.knowledgeBaseConfiguration != null ? this.knowledgeBaseConfiguration.toBuilder() : null;
        }

        public final void setKnowledgeBaseConfiguration(KnowledgeBaseConfiguration.BuilderImpl knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration != null ? knowledgeBaseConfiguration.build() : null;
        }

        @Override
        public final Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration knowledgeBaseConfiguration) {
            this.knowledgeBaseConfiguration = knowledgeBaseConfiguration;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final StorageConfiguration.Builder getStorageConfiguration() {
            return this.storageConfiguration != null ? this.storageConfiguration.toBuilder() : null;
        }

        public final void setStorageConfiguration(StorageConfiguration.BuilderImpl storageConfiguration) {
            this.storageConfiguration = storageConfiguration != null ? storageConfiguration.build() : null;
        }

        @Override
        public final Builder storageConfiguration(StorageConfiguration storageConfiguration) {
            this.storageConfiguration = storageConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateKnowledgeBaseRequest build() {
            return new CreateKnowledgeBaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockAgentRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateKnowledgeBaseRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder knowledgeBaseConfiguration(KnowledgeBaseConfiguration var1);

        default public Builder knowledgeBaseConfiguration(Consumer<KnowledgeBaseConfiguration.Builder> knowledgeBaseConfiguration) {
            return this.knowledgeBaseConfiguration((KnowledgeBaseConfiguration)((KnowledgeBaseConfiguration.Builder)KnowledgeBaseConfiguration.builder().applyMutation(knowledgeBaseConfiguration)).build());
        }

        public Builder name(String var1);

        public Builder roleArn(String var1);

        public Builder storageConfiguration(StorageConfiguration var1);

        default public Builder storageConfiguration(Consumer<StorageConfiguration.Builder> storageConfiguration) {
            return this.storageConfiguration((StorageConfiguration)((StorageConfiguration.Builder)StorageConfiguration.builder().applyMutation(storageConfiguration)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

