/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilterAttribute;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilterOperator;
import software.amazon.awssdk.services.bedrockagent.model.IngestionJobFilterValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IngestionJobFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IngestionJobFilter> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attribute").getter(IngestionJobFilter.getter(IngestionJobFilter::attributeAsString)).setter(IngestionJobFilter.setter(Builder::attribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attribute").build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operator").getter(IngestionJobFilter.getter(IngestionJobFilter::operatorAsString)).setter(IngestionJobFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operator").build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(IngestionJobFilter.getter(IngestionJobFilter::values)).setter(IngestionJobFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD, OPERATOR_FIELD, VALUES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String attribute;
    private final String operator;
    private final List<String> values;

    private IngestionJobFilter(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.operator = builder.operator;
        this.values = builder.values;
    }

    public final IngestionJobFilterAttribute attribute() {
        return IngestionJobFilterAttribute.fromValue(this.attribute);
    }

    public final String attributeAsString() {
        return this.attribute;
    }

    public final IngestionJobFilterOperator operator() {
        return IngestionJobFilterOperator.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IngestionJobFilter)) {
            return false;
        }
        IngestionJobFilter other = (IngestionJobFilter)obj;
        return Objects.equals(this.attributeAsString(), other.attributeAsString()) && Objects.equals(this.operatorAsString(), other.operatorAsString()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"IngestionJobFilter").add("Attribute", (Object)this.attributeAsString()).add("Operator", (Object)this.operatorAsString()).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attribute": {
                return Optional.ofNullable(clazz.cast(this.attributeAsString()));
            }
            case "operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IngestionJobFilter, T> g) {
        return obj -> g.apply((IngestionJobFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attribute;
        private String operator;
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IngestionJobFilter model) {
            this.attribute(model.attribute);
            this.operator(model.operator);
            this.values(model.values);
        }

        public final String getAttribute() {
            return this.attribute;
        }

        public final void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        @Override
        public final Builder attribute(String attribute) {
            this.attribute = attribute;
            return this;
        }

        @Override
        public final Builder attribute(IngestionJobFilterAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(IngestionJobFilterOperator operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = IngestionJobFilterValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = IngestionJobFilterValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public IngestionJobFilter build() {
            return new IngestionJobFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IngestionJobFilter> {
        public Builder attribute(String var1);

        public Builder attribute(IngestionJobFilterAttribute var1);

        public Builder operator(String var1);

        public Builder operator(IngestionJobFilterOperator var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

