/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Update Agent Alias Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAgentAliasRequest extends BedrockAgentRequest implements
        ToCopyableBuilder<UpdateAgentAliasRequest.Builder, UpdateAgentAliasRequest> {
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(UpdateAgentAliasRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(UpdateAgentAliasRequest::agentAliasId))
            .setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()).build();

    private static final SdkField<String> AGENT_ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasName").getter(getter(UpdateAgentAliasRequest::agentAliasName))
            .setter(setter(Builder::agentAliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAliasName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateAgentAliasRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<AgentAliasRoutingConfigurationListItem>> ROUTING_CONFIGURATION_FIELD = SdkField
            .<List<AgentAliasRoutingConfigurationListItem>> builder(MarshallingType.LIST)
            .memberName("routingConfiguration")
            .getter(getter(UpdateAgentAliasRequest::routingConfiguration))
            .setter(setter(Builder::routingConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routingConfiguration").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentAliasRoutingConfigurationListItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentAliasRoutingConfigurationListItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_ID_FIELD,
            AGENT_ALIAS_ID_FIELD, AGENT_ALIAS_NAME_FIELD, DESCRIPTION_FIELD, ROUTING_CONFIGURATION_FIELD));

    private final String agentId;

    private final String agentAliasId;

    private final String agentAliasName;

    private final String description;

    private final List<AgentAliasRoutingConfigurationListItem> routingConfiguration;

    private UpdateAgentAliasRequest(BuilderImpl builder) {
        super(builder);
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.agentAliasName = builder.agentAliasName;
        this.description = builder.description;
        this.routingConfiguration = builder.routingConfiguration;
    }

    /**
     * <p>
     * Id generated at the server side when an Agent is created
     * </p>
     * 
     * @return Id generated at the server side when an Agent is created
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Id generated at the server side when an Agent Alias is created
     * </p>
     * 
     * @return Id generated at the server side when an Agent Alias is created
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * Returns the value of the AgentAliasName property for this object.
     * 
     * @return The value of the AgentAliasName property for this object.
     */
    public final String agentAliasName() {
        return agentAliasName;
    }

    /**
     * Returns the value of the Description property for this object.
     * 
     * @return The value of the Description property for this object.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the RoutingConfiguration property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRoutingConfiguration() {
        return routingConfiguration != null && !(routingConfiguration instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the RoutingConfiguration property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRoutingConfiguration} method.
     * </p>
     * 
     * @return The value of the RoutingConfiguration property for this object.
     */
    public final List<AgentAliasRoutingConfigurationListItem> routingConfiguration() {
        return routingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasRoutingConfiguration() ? routingConfiguration() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAgentAliasRequest)) {
            return false;
        }
        UpdateAgentAliasRequest other = (UpdateAgentAliasRequest) obj;
        return Objects.equals(agentId(), other.agentId()) && Objects.equals(agentAliasId(), other.agentAliasId())
                && Objects.equals(agentAliasName(), other.agentAliasName()) && Objects.equals(description(), other.description())
                && hasRoutingConfiguration() == other.hasRoutingConfiguration()
                && Objects.equals(routingConfiguration(), other.routingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAgentAliasRequest").add("AgentId", agentId()).add("AgentAliasId", agentAliasId())
                .add("AgentAliasName", agentAliasName()).add("Description", description())
                .add("RoutingConfiguration", hasRoutingConfiguration() ? routingConfiguration() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "agentAliasName":
            return Optional.ofNullable(clazz.cast(agentAliasName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "routingConfiguration":
            return Optional.ofNullable(clazz.cast(routingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAgentAliasRequest, T> g) {
        return obj -> g.apply((UpdateAgentAliasRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAgentAliasRequest> {
        /**
         * <p>
         * Id generated at the server side when an Agent is created
         * </p>
         * 
         * @param agentId
         *        Id generated at the server side when an Agent is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Id generated at the server side when an Agent Alias is created
         * </p>
         * 
         * @param agentAliasId
         *        Id generated at the server side when an Agent Alias is created
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * Sets the value of the AgentAliasName property for this object.
         *
         * @param agentAliasName
         *        The new value for the AgentAliasName property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasName(String agentAliasName);

        /**
         * Sets the value of the Description property for this object.
         *
         * @param description
         *        The new value for the Description property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * Sets the value of the RoutingConfiguration property for this object.
         *
         * @param routingConfiguration
         *        The new value for the RoutingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration);

        /**
         * Sets the value of the RoutingConfiguration property for this object.
         *
         * @param routingConfiguration
         *        The new value for the RoutingConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routingConfiguration(AgentAliasRoutingConfigurationListItem... routingConfiguration);

        /**
         * Sets the value of the RoutingConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #routingConfiguration(List<AgentAliasRoutingConfigurationListItem>)}.
         * 
         * @param routingConfiguration
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentAliasRoutingConfigurationListItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routingConfiguration(java.util.Collection<AgentAliasRoutingConfigurationListItem>)
         */
        Builder routingConfiguration(Consumer<AgentAliasRoutingConfigurationListItem.Builder>... routingConfiguration);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRequest.BuilderImpl implements Builder {
        private String agentId;

        private String agentAliasId;

        private String agentAliasName;

        private String description;

        private List<AgentAliasRoutingConfigurationListItem> routingConfiguration = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAgentAliasRequest model) {
            super(model);
            agentId(model.agentId);
            agentAliasId(model.agentAliasId);
            agentAliasName(model.agentAliasName);
            description(model.description);
            routingConfiguration(model.routingConfiguration);
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getAgentAliasName() {
            return agentAliasName;
        }

        public final void setAgentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
        }

        @Override
        public final Builder agentAliasName(String agentAliasName) {
            this.agentAliasName = agentAliasName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<AgentAliasRoutingConfigurationListItem.Builder> getRoutingConfiguration() {
            List<AgentAliasRoutingConfigurationListItem.Builder> result = AgentAliasRoutingConfigurationCopier
                    .copyToBuilder(this.routingConfiguration);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRoutingConfiguration(
                Collection<AgentAliasRoutingConfigurationListItem.BuilderImpl> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copyFromBuilder(routingConfiguration);
        }

        @Override
        public final Builder routingConfiguration(Collection<AgentAliasRoutingConfigurationListItem> routingConfiguration) {
            this.routingConfiguration = AgentAliasRoutingConfigurationCopier.copy(routingConfiguration);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(AgentAliasRoutingConfigurationListItem... routingConfiguration) {
            routingConfiguration(Arrays.asList(routingConfiguration));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routingConfiguration(
                Consumer<AgentAliasRoutingConfigurationListItem.Builder>... routingConfiguration) {
            routingConfiguration(Stream.of(routingConfiguration)
                    .map(c -> AgentAliasRoutingConfigurationListItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAgentAliasRequest build() {
            return new UpdateAgentAliasRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
