/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * BasePromptConfiguration per Prompt Type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<PromptConfiguration.Builder, PromptConfiguration> {
    private static final SdkField<String> PROMPT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptType").getter(getter(PromptConfiguration::promptTypeAsString)).setter(setter(Builder::promptType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptType").build()).build();

    private static final SdkField<String> PROMPT_CREATION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptCreationMode").getter(getter(PromptConfiguration::promptCreationModeAsString))
            .setter(setter(Builder::promptCreationMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptCreationMode").build())
            .build();

    private static final SdkField<String> PROMPT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("promptState").getter(getter(PromptConfiguration::promptStateAsString))
            .setter(setter(Builder::promptState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptState").build()).build();

    private static final SdkField<String> BASE_PROMPT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("basePromptTemplate").getter(getter(PromptConfiguration::basePromptTemplate))
            .setter(setter(Builder::basePromptTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("basePromptTemplate").build())
            .build();

    private static final SdkField<InferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField
            .<InferenceConfiguration> builder(MarshallingType.SDK_POJO).memberName("inferenceConfiguration")
            .getter(getter(PromptConfiguration::inferenceConfiguration)).setter(setter(Builder::inferenceConfiguration))
            .constructor(InferenceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build())
            .build();

    private static final SdkField<String> PARSER_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parserMode").getter(getter(PromptConfiguration::parserModeAsString)).setter(setter(Builder::parserMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parserMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROMPT_TYPE_FIELD,
            PROMPT_CREATION_MODE_FIELD, PROMPT_STATE_FIELD, BASE_PROMPT_TEMPLATE_FIELD, INFERENCE_CONFIGURATION_FIELD,
            PARSER_MODE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String promptType;

    private final String promptCreationMode;

    private final String promptState;

    private final String basePromptTemplate;

    private final InferenceConfiguration inferenceConfiguration;

    private final String parserMode;

    private PromptConfiguration(BuilderImpl builder) {
        this.promptType = builder.promptType;
        this.promptCreationMode = builder.promptCreationMode;
        this.promptState = builder.promptState;
        this.basePromptTemplate = builder.basePromptTemplate;
        this.inferenceConfiguration = builder.inferenceConfiguration;
        this.parserMode = builder.parserMode;
    }

    /**
     * Returns the value of the PromptType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptType} will
     * return {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptTypeAsString}.
     * </p>
     * 
     * @return The value of the PromptType property for this object.
     * @see PromptType
     */
    public final PromptType promptType() {
        return PromptType.fromValue(promptType);
    }

    /**
     * Returns the value of the PromptType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptType} will
     * return {@link PromptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptTypeAsString}.
     * </p>
     * 
     * @return The value of the PromptType property for this object.
     * @see PromptType
     */
    public final String promptTypeAsString() {
        return promptType;
    }

    /**
     * Returns the value of the PromptCreationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return The value of the PromptCreationMode property for this object.
     * @see CreationMode
     */
    public final CreationMode promptCreationMode() {
        return CreationMode.fromValue(promptCreationMode);
    }

    /**
     * Returns the value of the PromptCreationMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #promptCreationMode} will return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #promptCreationModeAsString}.
     * </p>
     * 
     * @return The value of the PromptCreationMode property for this object.
     * @see CreationMode
     */
    public final String promptCreationModeAsString() {
        return promptCreationMode;
    }

    /**
     * Returns the value of the PromptState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptState} will
     * return {@link PromptState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptStateAsString}.
     * </p>
     * 
     * @return The value of the PromptState property for this object.
     * @see PromptState
     */
    public final PromptState promptState() {
        return PromptState.fromValue(promptState);
    }

    /**
     * Returns the value of the PromptState property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #promptState} will
     * return {@link PromptState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #promptStateAsString}.
     * </p>
     * 
     * @return The value of the PromptState property for this object.
     * @see PromptState
     */
    public final String promptStateAsString() {
        return promptState;
    }

    /**
     * Returns the value of the BasePromptTemplate property for this object.
     * 
     * @return The value of the BasePromptTemplate property for this object.
     */
    public final String basePromptTemplate() {
        return basePromptTemplate;
    }

    /**
     * Returns the value of the InferenceConfiguration property for this object.
     * 
     * @return The value of the InferenceConfiguration property for this object.
     */
    public final InferenceConfiguration inferenceConfiguration() {
        return inferenceConfiguration;
    }

    /**
     * Returns the value of the ParserMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return The value of the ParserMode property for this object.
     * @see CreationMode
     */
    public final CreationMode parserMode() {
        return CreationMode.fromValue(parserMode);
    }

    /**
     * Returns the value of the ParserMode property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #parserMode} will
     * return {@link CreationMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #parserModeAsString}.
     * </p>
     * 
     * @return The value of the ParserMode property for this object.
     * @see CreationMode
     */
    public final String parserModeAsString() {
        return parserMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(promptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptCreationModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(promptStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(basePromptTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(inferenceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(parserModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptConfiguration)) {
            return false;
        }
        PromptConfiguration other = (PromptConfiguration) obj;
        return Objects.equals(promptTypeAsString(), other.promptTypeAsString())
                && Objects.equals(promptCreationModeAsString(), other.promptCreationModeAsString())
                && Objects.equals(promptStateAsString(), other.promptStateAsString())
                && Objects.equals(basePromptTemplate(), other.basePromptTemplate())
                && Objects.equals(inferenceConfiguration(), other.inferenceConfiguration())
                && Objects.equals(parserModeAsString(), other.parserModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptConfiguration").add("PromptType", promptTypeAsString())
                .add("PromptCreationMode", promptCreationModeAsString()).add("PromptState", promptStateAsString())
                .add("BasePromptTemplate", basePromptTemplate()).add("InferenceConfiguration", inferenceConfiguration())
                .add("ParserMode", parserModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "promptType":
            return Optional.ofNullable(clazz.cast(promptTypeAsString()));
        case "promptCreationMode":
            return Optional.ofNullable(clazz.cast(promptCreationModeAsString()));
        case "promptState":
            return Optional.ofNullable(clazz.cast(promptStateAsString()));
        case "basePromptTemplate":
            return Optional.ofNullable(clazz.cast(basePromptTemplate()));
        case "inferenceConfiguration":
            return Optional.ofNullable(clazz.cast(inferenceConfiguration()));
        case "parserMode":
            return Optional.ofNullable(clazz.cast(parserModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PromptConfiguration, T> g) {
        return obj -> g.apply((PromptConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptConfiguration> {
        /**
         * Sets the value of the PromptType property for this object.
         *
         * @param promptType
         *        The new value for the PromptType property for this object.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder promptType(String promptType);

        /**
         * Sets the value of the PromptType property for this object.
         *
         * @param promptType
         *        The new value for the PromptType property for this object.
         * @see PromptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptType
         */
        Builder promptType(PromptType promptType);

        /**
         * Sets the value of the PromptCreationMode property for this object.
         *
         * @param promptCreationMode
         *        The new value for the PromptCreationMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(String promptCreationMode);

        /**
         * Sets the value of the PromptCreationMode property for this object.
         *
         * @param promptCreationMode
         *        The new value for the PromptCreationMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder promptCreationMode(CreationMode promptCreationMode);

        /**
         * Sets the value of the PromptState property for this object.
         *
         * @param promptState
         *        The new value for the PromptState property for this object.
         * @see PromptState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptState
         */
        Builder promptState(String promptState);

        /**
         * Sets the value of the PromptState property for this object.
         *
         * @param promptState
         *        The new value for the PromptState property for this object.
         * @see PromptState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PromptState
         */
        Builder promptState(PromptState promptState);

        /**
         * Sets the value of the BasePromptTemplate property for this object.
         *
         * @param basePromptTemplate
         *        The new value for the BasePromptTemplate property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder basePromptTemplate(String basePromptTemplate);

        /**
         * Sets the value of the InferenceConfiguration property for this object.
         *
         * @param inferenceConfiguration
         *        The new value for the InferenceConfiguration property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration);

        /**
         * Sets the value of the InferenceConfiguration property for this object.
         *
         * This is a convenience method that creates an instance of the {@link InferenceConfiguration.Builder} avoiding
         * the need to create one manually via {@link InferenceConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InferenceConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #inferenceConfiguration(InferenceConfiguration)}.
         * 
         * @param inferenceConfiguration
         *        a consumer that will call methods on {@link InferenceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inferenceConfiguration(InferenceConfiguration)
         */
        default Builder inferenceConfiguration(Consumer<InferenceConfiguration.Builder> inferenceConfiguration) {
            return inferenceConfiguration(InferenceConfiguration.builder().applyMutation(inferenceConfiguration).build());
        }

        /**
         * Sets the value of the ParserMode property for this object.
         *
         * @param parserMode
         *        The new value for the ParserMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(String parserMode);

        /**
         * Sets the value of the ParserMode property for this object.
         *
         * @param parserMode
         *        The new value for the ParserMode property for this object.
         * @see CreationMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CreationMode
         */
        Builder parserMode(CreationMode parserMode);
    }

    static final class BuilderImpl implements Builder {
        private String promptType;

        private String promptCreationMode;

        private String promptState;

        private String basePromptTemplate;

        private InferenceConfiguration inferenceConfiguration;

        private String parserMode;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptConfiguration model) {
            promptType(model.promptType);
            promptCreationMode(model.promptCreationMode);
            promptState(model.promptState);
            basePromptTemplate(model.basePromptTemplate);
            inferenceConfiguration(model.inferenceConfiguration);
            parserMode(model.parserMode);
        }

        public final String getPromptType() {
            return promptType;
        }

        public final void setPromptType(String promptType) {
            this.promptType = promptType;
        }

        @Override
        public final Builder promptType(String promptType) {
            this.promptType = promptType;
            return this;
        }

        @Override
        public final Builder promptType(PromptType promptType) {
            this.promptType(promptType == null ? null : promptType.toString());
            return this;
        }

        public final String getPromptCreationMode() {
            return promptCreationMode;
        }

        public final void setPromptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
        }

        @Override
        public final Builder promptCreationMode(String promptCreationMode) {
            this.promptCreationMode = promptCreationMode;
            return this;
        }

        @Override
        public final Builder promptCreationMode(CreationMode promptCreationMode) {
            this.promptCreationMode(promptCreationMode == null ? null : promptCreationMode.toString());
            return this;
        }

        public final String getPromptState() {
            return promptState;
        }

        public final void setPromptState(String promptState) {
            this.promptState = promptState;
        }

        @Override
        public final Builder promptState(String promptState) {
            this.promptState = promptState;
            return this;
        }

        @Override
        public final Builder promptState(PromptState promptState) {
            this.promptState(promptState == null ? null : promptState.toString());
            return this;
        }

        public final String getBasePromptTemplate() {
            return basePromptTemplate;
        }

        public final void setBasePromptTemplate(String basePromptTemplate) {
            this.basePromptTemplate = basePromptTemplate;
        }

        @Override
        public final Builder basePromptTemplate(String basePromptTemplate) {
            this.basePromptTemplate = basePromptTemplate;
            return this;
        }

        public final InferenceConfiguration.Builder getInferenceConfiguration() {
            return inferenceConfiguration != null ? inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(InferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(InferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        public final String getParserMode() {
            return parserMode;
        }

        public final void setParserMode(String parserMode) {
            this.parserMode = parserMode;
        }

        @Override
        public final Builder parserMode(String parserMode) {
            this.parserMode = parserMode;
            return this;
        }

        @Override
        public final Builder parserMode(CreationMode parserMode) {
            this.parserMode(parserMode == null ? null : parserMode.toString());
            return this;
        }

        @Override
        public PromptConfiguration build() {
            return new PromptConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
