/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagent.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List Agent Response
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListAgentsResponse extends BedrockAgentResponse implements
        ToCopyableBuilder<ListAgentsResponse.Builder, ListAgentsResponse> {
    private static final SdkField<List<AgentSummary>> AGENT_SUMMARIES_FIELD = SdkField
            .<List<AgentSummary>> builder(MarshallingType.LIST)
            .memberName("agentSummaries")
            .getter(getter(ListAgentsResponse::agentSummaries))
            .setter(setter(Builder::agentSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AgentSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(AgentSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListAgentsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_SUMMARIES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<AgentSummary> agentSummaries;

    private final String nextToken;

    private ListAgentsResponse(BuilderImpl builder) {
        super(builder);
        this.agentSummaries = builder.agentSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the AgentSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAgentSummaries() {
        return agentSummaries != null && !(agentSummaries instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the AgentSummaries property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgentSummaries} method.
     * </p>
     * 
     * @return The value of the AgentSummaries property for this object.
     */
    public final List<AgentSummary> agentSummaries() {
        return agentSummaries;
    }

    /**
     * Returns the value of the NextToken property for this object.
     * 
     * @return The value of the NextToken property for this object.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgentSummaries() ? agentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAgentsResponse)) {
            return false;
        }
        ListAgentsResponse other = (ListAgentsResponse) obj;
        return hasAgentSummaries() == other.hasAgentSummaries() && Objects.equals(agentSummaries(), other.agentSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListAgentsResponse").add("AgentSummaries", hasAgentSummaries() ? agentSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentSummaries":
            return Optional.ofNullable(clazz.cast(agentSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAgentsResponse, T> g) {
        return obj -> g.apply((ListAgentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListAgentsResponse> {
        /**
         * Sets the value of the AgentSummaries property for this object.
         *
         * @param agentSummaries
         *        The new value for the AgentSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentSummaries(Collection<AgentSummary> agentSummaries);

        /**
         * Sets the value of the AgentSummaries property for this object.
         *
         * @param agentSummaries
         *        The new value for the AgentSummaries property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentSummaries(AgentSummary... agentSummaries);

        /**
         * Sets the value of the AgentSummaries property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentSummary.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrockagent.model.AgentSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagent.model.AgentSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #agentSummaries(List<AgentSummary>)}.
         * 
         * @param agentSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagent.model.AgentSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agentSummaries(java.util.Collection<AgentSummary>)
         */
        Builder agentSummaries(Consumer<AgentSummary.Builder>... agentSummaries);

        /**
         * Sets the value of the NextToken property for this object.
         *
         * @param nextToken
         *        The new value for the NextToken property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends BedrockAgentResponse.BuilderImpl implements Builder {
        private List<AgentSummary> agentSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAgentsResponse model) {
            super(model);
            agentSummaries(model.agentSummaries);
            nextToken(model.nextToken);
        }

        public final List<AgentSummary.Builder> getAgentSummaries() {
            List<AgentSummary.Builder> result = AgentSummariesCopier.copyToBuilder(this.agentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgentSummaries(Collection<AgentSummary.BuilderImpl> agentSummaries) {
            this.agentSummaries = AgentSummariesCopier.copyFromBuilder(agentSummaries);
        }

        @Override
        public final Builder agentSummaries(Collection<AgentSummary> agentSummaries) {
            this.agentSummaries = AgentSummariesCopier.copy(agentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentSummaries(AgentSummary... agentSummaries) {
            agentSummaries(Arrays.asList(agentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentSummaries(Consumer<AgentSummary.Builder>... agentSummaries) {
            agentSummaries(Stream.of(agentSummaries).map(c -> AgentSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAgentsResponse build() {
            return new ListAgentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
