/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateCustomModelDeploymentRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, UpdateCustomModelDeploymentRequest> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(UpdateCustomModelDeploymentRequest.getter(UpdateCustomModelDeploymentRequest::modelArn)).setter(UpdateCustomModelDeploymentRequest.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelDeploymentIdentifier").getter(UpdateCustomModelDeploymentRequest.getter(UpdateCustomModelDeploymentRequest::customModelDeploymentIdentifier)).setter(UpdateCustomModelDeploymentRequest.setter(Builder::customModelDeploymentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("customModelDeploymentIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD, CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateCustomModelDeploymentRequest.memberNameToFieldInitializer();
    private final String modelArn;
    private final String customModelDeploymentIdentifier;

    private UpdateCustomModelDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.customModelDeploymentIdentifier = builder.customModelDeploymentIdentifier;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final String customModelDeploymentIdentifier() {
        return this.customModelDeploymentIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelDeploymentIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCustomModelDeploymentRequest)) {
            return false;
        }
        UpdateCustomModelDeploymentRequest other = (UpdateCustomModelDeploymentRequest)((Object)obj);
        return Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.customModelDeploymentIdentifier(), other.customModelDeploymentIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateCustomModelDeploymentRequest").add("ModelArn", (Object)this.modelArn()).add("CustomModelDeploymentIdentifier", (Object)this.customModelDeploymentIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "customModelDeploymentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.customModelDeploymentIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("customModelDeploymentIdentifier", CUSTOM_MODEL_DEPLOYMENT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCustomModelDeploymentRequest, T> g) {
        return obj -> g.apply((UpdateCustomModelDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String modelArn;
        private String customModelDeploymentIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCustomModelDeploymentRequest model) {
            super(model);
            this.modelArn(model.modelArn);
            this.customModelDeploymentIdentifier(model.customModelDeploymentIdentifier);
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getCustomModelDeploymentIdentifier() {
            return this.customModelDeploymentIdentifier;
        }

        public final void setCustomModelDeploymentIdentifier(String customModelDeploymentIdentifier) {
            this.customModelDeploymentIdentifier = customModelDeploymentIdentifier;
        }

        @Override
        public final Builder customModelDeploymentIdentifier(String customModelDeploymentIdentifier) {
            this.customModelDeploymentIdentifier = customModelDeploymentIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCustomModelDeploymentRequest build() {
            return new UpdateCustomModelDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateCustomModelDeploymentRequest> {
        public Builder modelArn(String var1);

        public Builder customModelDeploymentIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

