/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailInferenceInputConfiguration;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEnforcedGuardrailConfigurationRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, PutEnforcedGuardrailConfigurationRequest> {
    private static final SdkField<String> CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("configId").getter(PutEnforcedGuardrailConfigurationRequest.getter(PutEnforcedGuardrailConfigurationRequest::configId)).setter(PutEnforcedGuardrailConfigurationRequest.setter(Builder::configId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configId").build()}).build();
    private static final SdkField<AccountEnforcedGuardrailInferenceInputConfiguration> GUARDRAIL_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardrailInferenceConfig").getter(PutEnforcedGuardrailConfigurationRequest.getter(PutEnforcedGuardrailConfigurationRequest::guardrailInferenceConfig)).setter(PutEnforcedGuardrailConfigurationRequest.setter(Builder::guardrailInferenceConfig)).constructor(AccountEnforcedGuardrailInferenceInputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailInferenceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIG_ID_FIELD, GUARDRAIL_INFERENCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEnforcedGuardrailConfigurationRequest.memberNameToFieldInitializer();
    private final String configId;
    private final AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig;

    private PutEnforcedGuardrailConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.configId = builder.configId;
        this.guardrailInferenceConfig = builder.guardrailInferenceConfig;
    }

    public final String configId() {
        return this.configId;
    }

    public final AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig() {
        return this.guardrailInferenceConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailInferenceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEnforcedGuardrailConfigurationRequest)) {
            return false;
        }
        PutEnforcedGuardrailConfigurationRequest other = (PutEnforcedGuardrailConfigurationRequest)((Object)obj);
        return Objects.equals(this.configId(), other.configId()) && Objects.equals(this.guardrailInferenceConfig(), other.guardrailInferenceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"PutEnforcedGuardrailConfigurationRequest").add("ConfigId", (Object)this.configId()).add("GuardrailInferenceConfig", (Object)this.guardrailInferenceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "configId": {
                return Optional.ofNullable(clazz.cast(this.configId()));
            }
            case "guardrailInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.guardrailInferenceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("configId", CONFIG_ID_FIELD);
        map.put("guardrailInferenceConfig", GUARDRAIL_INFERENCE_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEnforcedGuardrailConfigurationRequest, T> g) {
        return obj -> g.apply((PutEnforcedGuardrailConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String configId;
        private AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(PutEnforcedGuardrailConfigurationRequest model) {
            super(model);
            this.configId(model.configId);
            this.guardrailInferenceConfig(model.guardrailInferenceConfig);
        }

        public final String getConfigId() {
            return this.configId;
        }

        public final void setConfigId(String configId) {
            this.configId = configId;
        }

        @Override
        public final Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public final AccountEnforcedGuardrailInferenceInputConfiguration.Builder getGuardrailInferenceConfig() {
            return this.guardrailInferenceConfig != null ? this.guardrailInferenceConfig.toBuilder() : null;
        }

        public final void setGuardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration.BuilderImpl guardrailInferenceConfig) {
            this.guardrailInferenceConfig = guardrailInferenceConfig != null ? guardrailInferenceConfig.build() : null;
        }

        @Override
        public final Builder guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration guardrailInferenceConfig) {
            this.guardrailInferenceConfig = guardrailInferenceConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEnforcedGuardrailConfigurationRequest build() {
            return new PutEnforcedGuardrailConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEnforcedGuardrailConfigurationRequest> {
        public Builder configId(String var1);

        public Builder guardrailInferenceConfig(AccountEnforcedGuardrailInferenceInputConfiguration var1);

        default public Builder guardrailInferenceConfig(Consumer<AccountEnforcedGuardrailInferenceInputConfiguration.Builder> guardrailInferenceConfig) {
            return this.guardrailInferenceConfig((AccountEnforcedGuardrailInferenceInputConfiguration)((AccountEnforcedGuardrailInferenceInputConfiguration.Builder)AccountEnforcedGuardrailInferenceInputConfiguration.builder().applyMutation(guardrailInferenceConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

