/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.RerankingMetadataSelectionMode;
import software.amazon.awssdk.services.bedrock.model.RerankingMetadataSelectiveModeConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataConfigurationForReranking
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataConfigurationForReranking> {
    private static final SdkField<String> SELECTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("selectionMode").getter(MetadataConfigurationForReranking.getter(MetadataConfigurationForReranking::selectionModeAsString)).setter(MetadataConfigurationForReranking.setter(Builder::selectionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectionMode").build()}).build();
    private static final SdkField<RerankingMetadataSelectiveModeConfiguration> SELECTIVE_MODE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selectiveModeConfiguration").getter(MetadataConfigurationForReranking.getter(MetadataConfigurationForReranking::selectiveModeConfiguration)).setter(MetadataConfigurationForReranking.setter(Builder::selectiveModeConfiguration)).constructor(RerankingMetadataSelectiveModeConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selectiveModeConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTION_MODE_FIELD, SELECTIVE_MODE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetadataConfigurationForReranking.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String selectionMode;
    private final RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration;

    private MetadataConfigurationForReranking(BuilderImpl builder) {
        this.selectionMode = builder.selectionMode;
        this.selectiveModeConfiguration = builder.selectiveModeConfiguration;
    }

    public final RerankingMetadataSelectionMode selectionMode() {
        return RerankingMetadataSelectionMode.fromValue(this.selectionMode);
    }

    public final String selectionModeAsString() {
        return this.selectionMode;
    }

    public final RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration() {
        return this.selectiveModeConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.selectionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectiveModeConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataConfigurationForReranking)) {
            return false;
        }
        MetadataConfigurationForReranking other = (MetadataConfigurationForReranking)obj;
        return Objects.equals(this.selectionModeAsString(), other.selectionModeAsString()) && Objects.equals(this.selectiveModeConfiguration(), other.selectiveModeConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataConfigurationForReranking").add("SelectionMode", (Object)this.selectionModeAsString()).add("SelectiveModeConfiguration", (Object)this.selectiveModeConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "selectionMode": {
                return Optional.ofNullable(clazz.cast(this.selectionModeAsString()));
            }
            case "selectiveModeConfiguration": {
                return Optional.ofNullable(clazz.cast(this.selectiveModeConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("selectionMode", SELECTION_MODE_FIELD);
        map.put("selectiveModeConfiguration", SELECTIVE_MODE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetadataConfigurationForReranking, T> g) {
        return obj -> g.apply((MetadataConfigurationForReranking)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String selectionMode;
        private RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataConfigurationForReranking model) {
            this.selectionMode(model.selectionMode);
            this.selectiveModeConfiguration(model.selectiveModeConfiguration);
        }

        public final String getSelectionMode() {
            return this.selectionMode;
        }

        public final void setSelectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
        }

        @Override
        public final Builder selectionMode(String selectionMode) {
            this.selectionMode = selectionMode;
            return this;
        }

        @Override
        public final Builder selectionMode(RerankingMetadataSelectionMode selectionMode) {
            this.selectionMode(selectionMode == null ? null : selectionMode.toString());
            return this;
        }

        public final RerankingMetadataSelectiveModeConfiguration.Builder getSelectiveModeConfiguration() {
            return this.selectiveModeConfiguration != null ? this.selectiveModeConfiguration.toBuilder() : null;
        }

        public final void setSelectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration.BuilderImpl selectiveModeConfiguration) {
            this.selectiveModeConfiguration = selectiveModeConfiguration != null ? selectiveModeConfiguration.build() : null;
        }

        @Override
        public final Builder selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration selectiveModeConfiguration) {
            this.selectiveModeConfiguration = selectiveModeConfiguration;
            return this;
        }

        public MetadataConfigurationForReranking build() {
            return new MetadataConfigurationForReranking(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataConfigurationForReranking> {
        public Builder selectionMode(String var1);

        public Builder selectionMode(RerankingMetadataSelectionMode var1);

        public Builder selectiveModeConfiguration(RerankingMetadataSelectiveModeConfiguration var1);

        default public Builder selectiveModeConfiguration(Consumer<RerankingMetadataSelectiveModeConfiguration.Builder> selectiveModeConfiguration) {
            return this.selectiveModeConfiguration((RerankingMetadataSelectiveModeConfiguration)((RerankingMetadataSelectiveModeConfiguration.Builder)RerankingMetadataSelectiveModeConfiguration.builder().applyMutation(selectiveModeConfiguration)).build());
        }
    }
}

