/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAutomatedReasoningPolicyTestCaseRequest extends BedrockRequest implements
        ToCopyableBuilder<UpdateAutomatedReasoningPolicyTestCaseRequest.Builder, UpdateAutomatedReasoningPolicyTestCaseRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::testCaseId))
            .setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()).build();

    private static final SdkField<String> GUARD_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("guardContent").getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::guardContent))
            .setter(setter(Builder::guardContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()).build();

    private static final SdkField<String> QUERY_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queryContent").getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::queryContent))
            .setter(setter(Builder::queryContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queryContent").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedAt")
            .getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::lastUpdatedAt))
            .setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("expectedAggregatedFindingsResult")
            .getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::expectedAggregatedFindingsResultAsString))
            .setter(setter(Builder::expectedAggregatedFindingsResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expectedAggregatedFindingsResult")
                    .build()).build();

    private static final SdkField<Double> CONFIDENCE_THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("confidenceThreshold").getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::confidenceThreshold))
            .setter(setter(Builder::confidenceThreshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confidenceThreshold").build())
            .build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(UpdateAutomatedReasoningPolicyTestCaseRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientRequestToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            TEST_CASE_ID_FIELD, GUARD_CONTENT_FIELD, QUERY_CONTENT_FIELD, LAST_UPDATED_AT_FIELD,
            EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD, CONFIDENCE_THRESHOLD_FIELD, CLIENT_REQUEST_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String testCaseId;

    private final String guardContent;

    private final String queryContent;

    private final Instant lastUpdatedAt;

    private final String expectedAggregatedFindingsResult;

    private final Double confidenceThreshold;

    private final String clientRequestToken;

    private UpdateAutomatedReasoningPolicyTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.testCaseId = builder.testCaseId;
        this.guardContent = builder.guardContent;
        this.queryContent = builder.queryContent;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.expectedAggregatedFindingsResult = builder.expectedAggregatedFindingsResult;
        this.confidenceThreshold = builder.confidenceThreshold;
        this.clientRequestToken = builder.clientRequestToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy that contains the test.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy that contains the test.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The unique identifier of the test to update.
     * </p>
     * 
     * @return The unique identifier of the test to update.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The updated content to be validated by the Automated Reasoning policy.
     * </p>
     * 
     * @return The updated content to be validated by the Automated Reasoning policy.
     */
    public final String guardContent() {
        return guardContent;
    }

    /**
     * <p>
     * The updated input query or prompt that generated the content.
     * </p>
     * 
     * @return The updated input query or prompt that generated the content.
     */
    public final String queryContent() {
        return queryContent;
    }

    /**
     * <p>
     * The timestamp when the test was last updated. This is used as a concurrency token to prevent conflicting
     * modifications.
     * </p>
     * 
     * @return The timestamp when the test was last updated. This is used as a concurrency token to prevent conflicting
     *         modifications.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The updated expected result of the Automated Reasoning check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The updated expected result of the Automated Reasoning check.
     * @see AutomatedReasoningCheckResult
     */
    public final AutomatedReasoningCheckResult expectedAggregatedFindingsResult() {
        return AutomatedReasoningCheckResult.fromValue(expectedAggregatedFindingsResult);
    }

    /**
     * <p>
     * The updated expected result of the Automated Reasoning check.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #expectedAggregatedFindingsResult} will return
     * {@link AutomatedReasoningCheckResult#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #expectedAggregatedFindingsResultAsString}.
     * </p>
     * 
     * @return The updated expected result of the Automated Reasoning check.
     * @see AutomatedReasoningCheckResult
     */
    public final String expectedAggregatedFindingsResultAsString() {
        return expectedAggregatedFindingsResult;
    }

    /**
     * <p>
     * The updated minimum confidence level for logic validation. If null is provided, the threshold will be removed.
     * </p>
     * 
     * @return The updated minimum confidence level for logic validation. If null is provided, the threshold will be
     *         removed.
     */
    public final Double confidenceThreshold() {
        return confidenceThreshold;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this token
     * matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
     *         token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(queryContent());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(expectedAggregatedFindingsResultAsString());
        hashCode = 31 * hashCode + Objects.hashCode(confidenceThreshold());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAutomatedReasoningPolicyTestCaseRequest)) {
            return false;
        }
        UpdateAutomatedReasoningPolicyTestCaseRequest other = (UpdateAutomatedReasoningPolicyTestCaseRequest) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(testCaseId(), other.testCaseId())
                && Objects.equals(guardContent(), other.guardContent()) && Objects.equals(queryContent(), other.queryContent())
                && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(expectedAggregatedFindingsResultAsString(), other.expectedAggregatedFindingsResultAsString())
                && Objects.equals(confidenceThreshold(), other.confidenceThreshold())
                && Objects.equals(clientRequestToken(), other.clientRequestToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAutomatedReasoningPolicyTestCaseRequest").add("PolicyArn", policyArn())
                .add("TestCaseId", testCaseId())
                .add("GuardContent", guardContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("QueryContent", queryContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastUpdatedAt", lastUpdatedAt())
                .add("ExpectedAggregatedFindingsResult", expectedAggregatedFindingsResultAsString())
                .add("ConfidenceThreshold", confidenceThreshold()).add("ClientRequestToken", clientRequestToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "guardContent":
            return Optional.ofNullable(clazz.cast(guardContent()));
        case "queryContent":
            return Optional.ofNullable(clazz.cast(queryContent()));
        case "lastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "expectedAggregatedFindingsResult":
            return Optional.ofNullable(clazz.cast(expectedAggregatedFindingsResultAsString()));
        case "confidenceThreshold":
            return Optional.ofNullable(clazz.cast(confidenceThreshold()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("queryContent", QUERY_CONTENT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("expectedAggregatedFindingsResult", EXPECTED_AGGREGATED_FINDINGS_RESULT_FIELD);
        map.put("confidenceThreshold", CONFIDENCE_THRESHOLD_FIELD);
        map.put("clientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAutomatedReasoningPolicyTestCaseRequest, T> g) {
        return obj -> g.apply((UpdateAutomatedReasoningPolicyTestCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAutomatedReasoningPolicyTestCaseRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy that contains the test.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy that contains the test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The unique identifier of the test to update.
         * </p>
         * 
         * @param testCaseId
         *        The unique identifier of the test to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The updated content to be validated by the Automated Reasoning policy.
         * </p>
         * 
         * @param guardContent
         *        The updated content to be validated by the Automated Reasoning policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder guardContent(String guardContent);

        /**
         * <p>
         * The updated input query or prompt that generated the content.
         * </p>
         * 
         * @param queryContent
         *        The updated input query or prompt that generated the content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queryContent(String queryContent);

        /**
         * <p>
         * The timestamp when the test was last updated. This is used as a concurrency token to prevent conflicting
         * modifications.
         * </p>
         * 
         * @param lastUpdatedAt
         *        The timestamp when the test was last updated. This is used as a concurrency token to prevent
         *        conflicting modifications.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The updated expected result of the Automated Reasoning check.
         * </p>
         * 
         * @param expectedAggregatedFindingsResult
         *        The updated expected result of the Automated Reasoning check.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult);

        /**
         * <p>
         * The updated expected result of the Automated Reasoning check.
         * </p>
         * 
         * @param expectedAggregatedFindingsResult
         *        The updated expected result of the Automated Reasoning check.
         * @see AutomatedReasoningCheckResult
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningCheckResult
         */
        Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult);

        /**
         * <p>
         * The updated minimum confidence level for logic validation. If null is provided, the threshold will be
         * removed.
         * </p>
         * 
         * @param confidenceThreshold
         *        The updated minimum confidence level for logic validation. If null is provided, the threshold will be
         *        removed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confidenceThreshold(Double confidenceThreshold);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If this
         * token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than one time. If
         *        this token matches a previous request, Amazon Bedrock ignores the request, but does not return an
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String testCaseId;

        private String guardContent;

        private String queryContent;

        private Instant lastUpdatedAt;

        private String expectedAggregatedFindingsResult;

        private Double confidenceThreshold;

        private String clientRequestToken;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAutomatedReasoningPolicyTestCaseRequest model) {
            super(model);
            policyArn(model.policyArn);
            testCaseId(model.testCaseId);
            guardContent(model.guardContent);
            queryContent(model.queryContent);
            lastUpdatedAt(model.lastUpdatedAt);
            expectedAggregatedFindingsResult(model.expectedAggregatedFindingsResult);
            confidenceThreshold(model.confidenceThreshold);
            clientRequestToken(model.clientRequestToken);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getGuardContent() {
            return guardContent;
        }

        public final void setGuardContent(String guardContent) {
            this.guardContent = guardContent;
        }

        @Override
        public final Builder guardContent(String guardContent) {
            this.guardContent = guardContent;
            return this;
        }

        public final String getQueryContent() {
            return queryContent;
        }

        public final void setQueryContent(String queryContent) {
            this.queryContent = queryContent;
        }

        @Override
        public final Builder queryContent(String queryContent) {
            this.queryContent = queryContent;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getExpectedAggregatedFindingsResult() {
            return expectedAggregatedFindingsResult;
        }

        public final void setExpectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(String expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult = expectedAggregatedFindingsResult;
            return this;
        }

        @Override
        public final Builder expectedAggregatedFindingsResult(AutomatedReasoningCheckResult expectedAggregatedFindingsResult) {
            this.expectedAggregatedFindingsResult(expectedAggregatedFindingsResult == null ? null
                    : expectedAggregatedFindingsResult.toString());
            return this;
        }

        public final Double getConfidenceThreshold() {
            return confidenceThreshold;
        }

        public final void setConfidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
        }

        @Override
        public final Builder confidenceThreshold(Double confidenceThreshold) {
            this.confidenceThreshold = confidenceThreshold;
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAutomatedReasoningPolicyTestCaseRequest build() {
            return new UpdateAutomatedReasoningPolicyTestCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
