/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAutomatedReasoningPolicyBuildWorkflowRequest extends BedrockRequest
        implements
        ToCopyableBuilder<StartAutomatedReasoningPolicyBuildWorkflowRequest.Builder, StartAutomatedReasoningPolicyBuildWorkflowRequest> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("policyArn").build()).build();

    private static final SdkField<String> BUILD_WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("buildWorkflowType")
            .getter(getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::buildWorkflowTypeAsString))
            .setter(setter(Builder::buildWorkflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("buildWorkflowType").build()).build();

    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientRequestToken")
            .getter(getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::clientRequestToken))
            .setter(setter(Builder::clientRequestToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("x-amz-client-token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<AutomatedReasoningPolicyBuildWorkflowSource> SOURCE_CONTENT_FIELD = SdkField
            .<AutomatedReasoningPolicyBuildWorkflowSource> builder(MarshallingType.SDK_POJO)
            .memberName("sourceContent")
            .getter(getter(StartAutomatedReasoningPolicyBuildWorkflowRequest::sourceContent))
            .setter(setter(Builder::sourceContent))
            .constructor(AutomatedReasoningPolicyBuildWorkflowSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceContent").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            BUILD_WORKFLOW_TYPE_FIELD, CLIENT_REQUEST_TOKEN_FIELD, SOURCE_CONTENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final String buildWorkflowType;

    private final String clientRequestToken;

    private final AutomatedReasoningPolicyBuildWorkflowSource sourceContent;

    private StartAutomatedReasoningPolicyBuildWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.buildWorkflowType = builder.buildWorkflowType;
        this.clientRequestToken = builder.clientRequestToken;
        this.sourceContent = builder.sourceContent;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to start the build workflow.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to start the build workflow.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR for
     * fixing existing policies).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildWorkflowType}
     * will return {@link AutomatedReasoningPolicyBuildWorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #buildWorkflowTypeAsString}.
     * </p>
     * 
     * @return The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR
     *         for fixing existing policies).
     * @see AutomatedReasoningPolicyBuildWorkflowType
     */
    public final AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType() {
        return AutomatedReasoningPolicyBuildWorkflowType.fromValue(buildWorkflowType);
    }

    /**
     * <p>
     * The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR for
     * fixing existing policies).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #buildWorkflowType}
     * will return {@link AutomatedReasoningPolicyBuildWorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #buildWorkflowTypeAsString}.
     * </p>
     * 
     * @return The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR
     *         for fixing existing policies).
     * @see AutomatedReasoningPolicyBuildWorkflowType
     */
    public final String buildWorkflowTypeAsString() {
        return buildWorkflowType;
    }

    /**
     * <p>
     * A unique, case-sensitive identifier to ensure that the operation completes no more than once. If this token
     * matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
     * </p>
     * 
     * @return A unique, case-sensitive identifier to ensure that the operation completes no more than once. If this
     *         token matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
     */
    public final String clientRequestToken() {
        return clientRequestToken;
    }

    /**
     * <p>
     * The source content for the build workflow, such as documents to analyze or repair instructions for existing
     * policies.
     * </p>
     * 
     * @return The source content for the build workflow, such as documents to analyze or repair instructions for
     *         existing policies.
     */
    public final AutomatedReasoningPolicyBuildWorkflowSource sourceContent() {
        return sourceContent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(buildWorkflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(sourceContent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomatedReasoningPolicyBuildWorkflowRequest)) {
            return false;
        }
        StartAutomatedReasoningPolicyBuildWorkflowRequest other = (StartAutomatedReasoningPolicyBuildWorkflowRequest) obj;
        return Objects.equals(policyArn(), other.policyArn())
                && Objects.equals(buildWorkflowTypeAsString(), other.buildWorkflowTypeAsString())
                && Objects.equals(clientRequestToken(), other.clientRequestToken())
                && Objects.equals(sourceContent(), other.sourceContent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAutomatedReasoningPolicyBuildWorkflowRequest").add("PolicyArn", policyArn())
                .add("BuildWorkflowType", buildWorkflowTypeAsString()).add("ClientRequestToken", clientRequestToken())
                .add("SourceContent", sourceContent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "buildWorkflowType":
            return Optional.ofNullable(clazz.cast(buildWorkflowTypeAsString()));
        case "clientRequestToken":
            return Optional.ofNullable(clazz.cast(clientRequestToken()));
        case "sourceContent":
            return Optional.ofNullable(clazz.cast(sourceContent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("buildWorkflowType", BUILD_WORKFLOW_TYPE_FIELD);
        map.put("x-amz-client-token", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("sourceContent", SOURCE_CONTENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartAutomatedReasoningPolicyBuildWorkflowRequest, T> g) {
        return obj -> g.apply((StartAutomatedReasoningPolicyBuildWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartAutomatedReasoningPolicyBuildWorkflowRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to start the build workflow.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the Automated Reasoning policy for which to start the build
         *        workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR for
         * fixing existing policies).
         * </p>
         * 
         * @param buildWorkflowType
         *        The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents,
         *        POLICY_REPAIR for fixing existing policies).
         * @see AutomatedReasoningPolicyBuildWorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowType
         */
        Builder buildWorkflowType(String buildWorkflowType);

        /**
         * <p>
         * The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents, POLICY_REPAIR for
         * fixing existing policies).
         * </p>
         * 
         * @param buildWorkflowType
         *        The type of build workflow to start (e.g., DOCUMENT_INGESTION for processing new documents,
         *        POLICY_REPAIR for fixing existing policies).
         * @see AutomatedReasoningPolicyBuildWorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutomatedReasoningPolicyBuildWorkflowType
         */
        Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType);

        /**
         * <p>
         * A unique, case-sensitive identifier to ensure that the operation completes no more than once. If this token
         * matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
         * </p>
         * 
         * @param clientRequestToken
         *        A unique, case-sensitive identifier to ensure that the operation completes no more than once. If this
         *        token matches a previous request, Amazon Bedrock ignores the request but doesn't return an error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientRequestToken(String clientRequestToken);

        /**
         * <p>
         * The source content for the build workflow, such as documents to analyze or repair instructions for existing
         * policies.
         * </p>
         * 
         * @param sourceContent
         *        The source content for the build workflow, such as documents to analyze or repair instructions for
         *        existing policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceContent(AutomatedReasoningPolicyBuildWorkflowSource sourceContent);

        /**
         * <p>
         * The source content for the build workflow, such as documents to analyze or repair instructions for existing
         * policies.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AutomatedReasoningPolicyBuildWorkflowSource.Builder} avoiding the need to create one manually via
         * {@link AutomatedReasoningPolicyBuildWorkflowSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyBuildWorkflowSource.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #sourceContent(AutomatedReasoningPolicyBuildWorkflowSource)}.
         * 
         * @param sourceContent
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyBuildWorkflowSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceContent(AutomatedReasoningPolicyBuildWorkflowSource)
         */
        default Builder sourceContent(Consumer<AutomatedReasoningPolicyBuildWorkflowSource.Builder> sourceContent) {
            return sourceContent(AutomatedReasoningPolicyBuildWorkflowSource.builder().applyMutation(sourceContent).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String policyArn;

        private String buildWorkflowType;

        private String clientRequestToken;

        private AutomatedReasoningPolicyBuildWorkflowSource sourceContent;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomatedReasoningPolicyBuildWorkflowRequest model) {
            super(model);
            policyArn(model.policyArn);
            buildWorkflowType(model.buildWorkflowType);
            clientRequestToken(model.clientRequestToken);
            sourceContent(model.sourceContent);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final String getBuildWorkflowType() {
            return buildWorkflowType;
        }

        public final void setBuildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
        }

        @Override
        public final Builder buildWorkflowType(String buildWorkflowType) {
            this.buildWorkflowType = buildWorkflowType;
            return this;
        }

        @Override
        public final Builder buildWorkflowType(AutomatedReasoningPolicyBuildWorkflowType buildWorkflowType) {
            this.buildWorkflowType(buildWorkflowType == null ? null : buildWorkflowType.toString());
            return this;
        }

        public final String getClientRequestToken() {
            return clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final AutomatedReasoningPolicyBuildWorkflowSource.Builder getSourceContent() {
            return sourceContent != null ? sourceContent.toBuilder() : null;
        }

        public final void setSourceContent(AutomatedReasoningPolicyBuildWorkflowSource.BuilderImpl sourceContent) {
            this.sourceContent = sourceContent != null ? sourceContent.build() : null;
        }

        @Override
        public final Builder sourceContent(AutomatedReasoningPolicyBuildWorkflowSource sourceContent) {
            this.sourceContent = sourceContent;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomatedReasoningPolicyBuildWorkflowRequest build() {
            return new StartAutomatedReasoningPolicyBuildWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
