/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the word policy to configured for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailWordPolicyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailWordPolicyConfig.Builder, GuardrailWordPolicyConfig> {
    private static final SdkField<List<GuardrailWordConfig>> WORDS_CONFIG_FIELD = SdkField
            .<List<GuardrailWordConfig>> builder(MarshallingType.LIST)
            .memberName("wordsConfig")
            .getter(getter(GuardrailWordPolicyConfig::wordsConfig))
            .setter(setter(Builder::wordsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wordsConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailWordConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailWordConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<GuardrailManagedWordsConfig>> MANAGED_WORD_LISTS_CONFIG_FIELD = SdkField
            .<List<GuardrailManagedWordsConfig>> builder(MarshallingType.LIST)
            .memberName("managedWordListsConfig")
            .getter(getter(GuardrailWordPolicyConfig::managedWordListsConfig))
            .setter(setter(Builder::managedWordListsConfig))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWordListsConfig").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<GuardrailManagedWordsConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(GuardrailManagedWordsConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORDS_CONFIG_FIELD,
            MANAGED_WORD_LISTS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<GuardrailWordConfig> wordsConfig;

    private final List<GuardrailManagedWordsConfig> managedWordListsConfig;

    private GuardrailWordPolicyConfig(BuilderImpl builder) {
        this.wordsConfig = builder.wordsConfig;
        this.managedWordListsConfig = builder.managedWordListsConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the WordsConfig property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWordsConfig() {
        return wordsConfig != null && !(wordsConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of words to configure for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWordsConfig} method.
     * </p>
     * 
     * @return A list of words to configure for the guardrail.
     */
    public final List<GuardrailWordConfig> wordsConfig() {
        return wordsConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedWordListsConfig property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedWordListsConfig() {
        return managedWordListsConfig != null && !(managedWordListsConfig instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed words to configure for the guardrail.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedWordListsConfig} method.
     * </p>
     * 
     * @return A list of managed words to configure for the guardrail.
     */
    public final List<GuardrailManagedWordsConfig> managedWordListsConfig() {
        return managedWordListsConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasWordsConfig() ? wordsConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedWordListsConfig() ? managedWordListsConfig() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordPolicyConfig)) {
            return false;
        }
        GuardrailWordPolicyConfig other = (GuardrailWordPolicyConfig) obj;
        return hasWordsConfig() == other.hasWordsConfig() && Objects.equals(wordsConfig(), other.wordsConfig())
                && hasManagedWordListsConfig() == other.hasManagedWordListsConfig()
                && Objects.equals(managedWordListsConfig(), other.managedWordListsConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailWordPolicyConfig").add("WordsConfig", hasWordsConfig() ? wordsConfig() : null)
                .add("ManagedWordListsConfig", hasManagedWordListsConfig() ? managedWordListsConfig() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "wordsConfig":
            return Optional.ofNullable(clazz.cast(wordsConfig()));
        case "managedWordListsConfig":
            return Optional.ofNullable(clazz.cast(managedWordListsConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("wordsConfig", WORDS_CONFIG_FIELD);
        map.put("managedWordListsConfig", MANAGED_WORD_LISTS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailWordPolicyConfig, T> g) {
        return obj -> g.apply((GuardrailWordPolicyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailWordPolicyConfig> {
        /**
         * <p>
         * A list of words to configure for the guardrail.
         * </p>
         * 
         * @param wordsConfig
         *        A list of words to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordsConfig(Collection<GuardrailWordConfig> wordsConfig);

        /**
         * <p>
         * A list of words to configure for the guardrail.
         * </p>
         * 
         * @param wordsConfig
         *        A list of words to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wordsConfig(GuardrailWordConfig... wordsConfig);

        /**
         * <p>
         * A list of words to configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #wordsConfig(List<GuardrailWordConfig>)}.
         * 
         * @param wordsConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailWordConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #wordsConfig(java.util.Collection<GuardrailWordConfig>)
         */
        Builder wordsConfig(Consumer<GuardrailWordConfig.Builder>... wordsConfig);

        /**
         * <p>
         * A list of managed words to configure for the guardrail.
         * </p>
         * 
         * @param managedWordListsConfig
         *        A list of managed words to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordListsConfig(Collection<GuardrailManagedWordsConfig> managedWordListsConfig);

        /**
         * <p>
         * A list of managed words to configure for the guardrail.
         * </p>
         * 
         * @param managedWordListsConfig
         *        A list of managed words to configure for the guardrail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedWordListsConfig(GuardrailManagedWordsConfig... managedWordListsConfig);

        /**
         * <p>
         * A list of managed words to configure for the guardrail.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsConfig.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsConfig.Builder#build()} is called
         * immediately and its result is passed to {@link #managedWordListsConfig(List<GuardrailManagedWordsConfig>)}.
         * 
         * @param managedWordListsConfig
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.GuardrailManagedWordsConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedWordListsConfig(java.util.Collection<GuardrailManagedWordsConfig>)
         */
        Builder managedWordListsConfig(Consumer<GuardrailManagedWordsConfig.Builder>... managedWordListsConfig);
    }

    static final class BuilderImpl implements Builder {
        private List<GuardrailWordConfig> wordsConfig = DefaultSdkAutoConstructList.getInstance();

        private List<GuardrailManagedWordsConfig> managedWordListsConfig = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailWordPolicyConfig model) {
            wordsConfig(model.wordsConfig);
            managedWordListsConfig(model.managedWordListsConfig);
        }

        public final List<GuardrailWordConfig.Builder> getWordsConfig() {
            List<GuardrailWordConfig.Builder> result = GuardrailWordsConfigCopier.copyToBuilder(this.wordsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWordsConfig(Collection<GuardrailWordConfig.BuilderImpl> wordsConfig) {
            this.wordsConfig = GuardrailWordsConfigCopier.copyFromBuilder(wordsConfig);
        }

        @Override
        public final Builder wordsConfig(Collection<GuardrailWordConfig> wordsConfig) {
            this.wordsConfig = GuardrailWordsConfigCopier.copy(wordsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wordsConfig(GuardrailWordConfig... wordsConfig) {
            wordsConfig(Arrays.asList(wordsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder wordsConfig(Consumer<GuardrailWordConfig.Builder>... wordsConfig) {
            wordsConfig(Stream.of(wordsConfig).map(c -> GuardrailWordConfig.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailManagedWordsConfig.Builder> getManagedWordListsConfig() {
            List<GuardrailManagedWordsConfig.Builder> result = GuardrailManagedWordListsConfigCopier
                    .copyToBuilder(this.managedWordListsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedWordListsConfig(Collection<GuardrailManagedWordsConfig.BuilderImpl> managedWordListsConfig) {
            this.managedWordListsConfig = GuardrailManagedWordListsConfigCopier.copyFromBuilder(managedWordListsConfig);
        }

        @Override
        public final Builder managedWordListsConfig(Collection<GuardrailManagedWordsConfig> managedWordListsConfig) {
            this.managedWordListsConfig = GuardrailManagedWordListsConfigCopier.copy(managedWordListsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordListsConfig(GuardrailManagedWordsConfig... managedWordListsConfig) {
            managedWordListsConfig(Arrays.asList(managedWordListsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordListsConfig(Consumer<GuardrailManagedWordsConfig.Builder>... managedWordListsConfig) {
            managedWordListsConfig(Stream.of(managedWordListsConfig)
                    .map(c -> GuardrailManagedWordsConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GuardrailWordPolicyConfig build() {
            return new GuardrailWordPolicyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
