/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The tier that your guardrail uses for content filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContentFiltersTier implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContentFiltersTier.Builder, GuardrailContentFiltersTier> {
    private static final SdkField<String> TIER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tierName").getter(getter(GuardrailContentFiltersTier::tierNameAsString))
            .setter(setter(Builder::tierName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tierName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tierName;

    private GuardrailContentFiltersTier(BuilderImpl builder) {
        this.tierName = builder.tierName;
    }

    /**
     * <p>
     * The tier that your guardrail uses for content filters. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and Spanish
     * languages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has more
     * comprehensive language support. This tier requires that your guardrail use <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
     * inference</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tierName} will
     * return {@link GuardrailContentFiltersTierName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tierNameAsString}.
     * </p>
     * 
     * @return The tier that your guardrail uses for content filters. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and
     *         Spanish languages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has
     *         more comprehensive language support. This tier requires that your guardrail use <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
     *         inference</a>.
     *         </p>
     *         </li>
     * @see GuardrailContentFiltersTierName
     */
    public final GuardrailContentFiltersTierName tierName() {
        return GuardrailContentFiltersTierName.fromValue(tierName);
    }

    /**
     * <p>
     * The tier that your guardrail uses for content filters. Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and Spanish
     * languages.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has more
     * comprehensive language support. This tier requires that your guardrail use <a
     * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
     * inference</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tierName} will
     * return {@link GuardrailContentFiltersTierName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #tierNameAsString}.
     * </p>
     * 
     * @return The tier that your guardrail uses for content filters. Valid values include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and
     *         Spanish languages.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has
     *         more comprehensive language support. This tier requires that your guardrail use <a
     *         href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
     *         inference</a>.
     *         </p>
     *         </li>
     * @see GuardrailContentFiltersTierName
     */
    public final String tierNameAsString() {
        return tierName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tierNameAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFiltersTier)) {
            return false;
        }
        GuardrailContentFiltersTier other = (GuardrailContentFiltersTier) obj;
        return Objects.equals(tierNameAsString(), other.tierNameAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContentFiltersTier")
                .add("TierName", tierNameAsString() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tierName":
            return Optional.ofNullable(clazz.cast(tierNameAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tierName", TIER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFiltersTier, T> g) {
        return obj -> g.apply((GuardrailContentFiltersTier) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContentFiltersTier> {
        /**
         * <p>
         * The tier that your guardrail uses for content filters. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and
         * Spanish languages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has more
         * comprehensive language support. This tier requires that your guardrail use <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
         * inference</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tierName
         *        The tier that your guardrail uses for content filters. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French,
         *        and Spanish languages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and
         *        has more comprehensive language support. This tier requires that your guardrail use <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
         *        inference</a>.
         *        </p>
         *        </li>
         * @see GuardrailContentFiltersTierName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFiltersTierName
         */
        Builder tierName(String tierName);

        /**
         * <p>
         * The tier that your guardrail uses for content filters. Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French, and
         * Spanish languages.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and has more
         * comprehensive language support. This tier requires that your guardrail use <a
         * href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
         * inference</a>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tierName
         *        The tier that your guardrail uses for content filters. Valid values include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CLASSIC</code> tier – Provides established guardrails functionality supporting English, French,
         *        and Spanish languages.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STANDARD</code> tier – Provides a more robust solution than the <code>CLASSIC</code> tier and
         *        has more comprehensive language support. This tier requires that your guardrail use <a
         *        href="https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-cross-region.html">cross-Region
         *        inference</a>.
         *        </p>
         *        </li>
         * @see GuardrailContentFiltersTierName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContentFiltersTierName
         */
        Builder tierName(GuardrailContentFiltersTierName tierName);
    }

    static final class BuilderImpl implements Builder {
        private String tierName;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFiltersTier model) {
            tierName(model.tierName);
        }

        public final String getTierName() {
            return tierName;
        }

        public final void setTierName(String tierName) {
            this.tierName = tierName;
        }

        @Override
        public final Builder tierName(String tierName) {
            this.tierName = tierName;
            return this;
        }

        @Override
        public final Builder tierName(GuardrailContentFiltersTierName tierName) {
            this.tierName(tierName == null ? null : tierName.toString());
            return this;
        }

        @Override
        public GuardrailContentFiltersTier build() {
            return new GuardrailContentFiltersTier(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
