/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for the grader used in reinforcement fine-tuning to evaluate model responses and provide reward
 * signals.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraderConfig implements SdkPojo, Serializable, ToCopyableBuilder<GraderConfig.Builder, GraderConfig> {
    private static final SdkField<LambdaGraderConfig> LAMBDA_GRADER_FIELD = SdkField
            .<LambdaGraderConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaGrader")
            .getter(getter(GraderConfig::lambdaGrader)).setter(setter(Builder::lambdaGrader))
            .constructor(LambdaGraderConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaGrader").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAMBDA_GRADER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final LambdaGraderConfig lambdaGrader;

    private final Type type;

    private GraderConfig(BuilderImpl builder) {
        this.lambdaGrader = builder.lambdaGrader;
        this.type = builder.type;
    }

    /**
     * <p>
     * Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide reward
     * signals in reinforcement fine-tuning.
     * </p>
     * 
     * @return Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide
     *         reward signals in reinforcement fine-tuning.
     */
    public final LambdaGraderConfig lambdaGrader() {
        return lambdaGrader;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lambdaGrader());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraderConfig)) {
            return false;
        }
        GraderConfig other = (GraderConfig) obj;
        return Objects.equals(lambdaGrader(), other.lambdaGrader());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GraderConfig").add("LambdaGrader", lambdaGrader()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lambdaGrader":
            return Optional.ofNullable(clazz.cast(lambdaGrader()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lambdaGrader()} initialized to the given value.
     *
     * <p>
     * Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide reward
     * signals in reinforcement fine-tuning.
     * </p>
     * 
     * @param lambdaGrader
     *        Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide
     *        reward signals in reinforcement fine-tuning.
     */
    public static GraderConfig fromLambdaGrader(LambdaGraderConfig lambdaGrader) {
        return builder().lambdaGrader(lambdaGrader).build();
    }

    /**
     * Create an instance of this class with {@link #lambdaGrader()} initialized to the given value.
     *
     * <p>
     * Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide reward
     * signals in reinforcement fine-tuning.
     * </p>
     * 
     * @param lambdaGrader
     *        Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide
     *        reward signals in reinforcement fine-tuning.
     */
    public static GraderConfig fromLambdaGrader(Consumer<LambdaGraderConfig.Builder> lambdaGrader) {
        LambdaGraderConfig.Builder builder = LambdaGraderConfig.builder();
        lambdaGrader.accept(builder);
        return fromLambdaGrader(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lambdaGrader", LAMBDA_GRADER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GraderConfig, T> g) {
        return obj -> g.apply((GraderConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraderConfig> {
        /**
         * <p>
         * Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide
         * reward signals in reinforcement fine-tuning.
         * </p>
         * 
         * @param lambdaGrader
         *        Configuration for using an AWS Lambda function as the grader for evaluating model responses and
         *        provide reward signals in reinforcement fine-tuning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaGrader(LambdaGraderConfig lambdaGrader);

        /**
         * <p>
         * Configuration for using an AWS Lambda function as the grader for evaluating model responses and provide
         * reward signals in reinforcement fine-tuning.
         * </p>
         * This is a convenience method that creates an instance of the {@link LambdaGraderConfig.Builder} avoiding the
         * need to create one manually via {@link LambdaGraderConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LambdaGraderConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #lambdaGrader(LambdaGraderConfig)}.
         * 
         * @param lambdaGrader
         *        a consumer that will call methods on {@link LambdaGraderConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaGrader(LambdaGraderConfig)
         */
        default Builder lambdaGrader(Consumer<LambdaGraderConfig.Builder> lambdaGrader) {
            return lambdaGrader(LambdaGraderConfig.builder().applyMutation(lambdaGrader).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LambdaGraderConfig lambdaGrader;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(GraderConfig model) {
            lambdaGrader(model.lambdaGrader);
        }

        public final LambdaGraderConfig.Builder getLambdaGrader() {
            return lambdaGrader != null ? lambdaGrader.toBuilder() : null;
        }

        public final void setLambdaGrader(LambdaGraderConfig.BuilderImpl lambdaGrader) {
            Object oldValue = this.lambdaGrader;
            this.lambdaGrader = lambdaGrader != null ? lambdaGrader.build() : null;
            handleUnionValueChange(Type.LAMBDA_GRADER, oldValue, this.lambdaGrader);
        }

        @Override
        public final Builder lambdaGrader(LambdaGraderConfig lambdaGrader) {
            Object oldValue = this.lambdaGrader;
            this.lambdaGrader = lambdaGrader;
            handleUnionValueChange(Type.LAMBDA_GRADER, oldValue, this.lambdaGrader);
            return this;
        }

        @Override
        public GraderConfig build() {
            return new GraderConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see GraderConfig#type()
     */
    public enum Type {
        LAMBDA_GRADER,

        UNKNOWN_TO_SDK_VERSION
    }
}
