/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetFoundationModelAvailabilityResponse extends BedrockResponse implements
        ToCopyableBuilder<GetFoundationModelAvailabilityResponse.Builder, GetFoundationModelAvailabilityResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelId").getter(getter(GetFoundationModelAvailabilityResponse::modelId))
            .setter(setter(Builder::modelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()).build();

    private static final SdkField<AgreementAvailability> AGREEMENT_AVAILABILITY_FIELD = SdkField
            .<AgreementAvailability> builder(MarshallingType.SDK_POJO).memberName("agreementAvailability")
            .getter(getter(GetFoundationModelAvailabilityResponse::agreementAvailability))
            .setter(setter(Builder::agreementAvailability)).constructor(AgreementAvailability::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementAvailability").build())
            .build();

    private static final SdkField<String> AUTHORIZATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationStatus")
            .getter(getter(GetFoundationModelAvailabilityResponse::authorizationStatusAsString))
            .setter(setter(Builder::authorizationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationStatus").build())
            .build();

    private static final SdkField<String> ENTITLEMENT_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("entitlementAvailability")
            .getter(getter(GetFoundationModelAvailabilityResponse::entitlementAvailabilityAsString))
            .setter(setter(Builder::entitlementAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementAvailability").build())
            .build();

    private static final SdkField<String> REGION_AVAILABILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("regionAvailability").getter(getter(GetFoundationModelAvailabilityResponse::regionAvailabilityAsString))
            .setter(setter(Builder::regionAvailability))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionAvailability").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD,
            AGREEMENT_AVAILABILITY_FIELD, AUTHORIZATION_STATUS_FIELD, ENTITLEMENT_AVAILABILITY_FIELD, REGION_AVAILABILITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String modelId;

    private final AgreementAvailability agreementAvailability;

    private final String authorizationStatus;

    private final String entitlementAvailability;

    private final String regionAvailability;

    private GetFoundationModelAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.agreementAvailability = builder.agreementAvailability;
        this.authorizationStatus = builder.authorizationStatus;
        this.entitlementAvailability = builder.entitlementAvailability;
        this.regionAvailability = builder.regionAvailability;
    }

    /**
     * <p>
     * The model Id of the foundation model.
     * </p>
     * 
     * @return The model Id of the foundation model.
     */
    public final String modelId() {
        return modelId;
    }

    /**
     * <p>
     * Agreement availability.
     * </p>
     * 
     * @return Agreement availability.
     */
    public final AgreementAvailability agreementAvailability() {
        return agreementAvailability;
    }

    /**
     * <p>
     * Authorization status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationStatus} will return {@link AuthorizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authorizationStatusAsString}.
     * </p>
     * 
     * @return Authorization status.
     * @see AuthorizationStatus
     */
    public final AuthorizationStatus authorizationStatus() {
        return AuthorizationStatus.fromValue(authorizationStatus);
    }

    /**
     * <p>
     * Authorization status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authorizationStatus} will return {@link AuthorizationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #authorizationStatusAsString}.
     * </p>
     * 
     * @return Authorization status.
     * @see AuthorizationStatus
     */
    public final String authorizationStatusAsString() {
        return authorizationStatus;
    }

    /**
     * <p>
     * Entitlement availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #entitlementAvailability} will return {@link EntitlementAvailability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #entitlementAvailabilityAsString}.
     * </p>
     * 
     * @return Entitlement availability.
     * @see EntitlementAvailability
     */
    public final EntitlementAvailability entitlementAvailability() {
        return EntitlementAvailability.fromValue(entitlementAvailability);
    }

    /**
     * <p>
     * Entitlement availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #entitlementAvailability} will return {@link EntitlementAvailability#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #entitlementAvailabilityAsString}.
     * </p>
     * 
     * @return Entitlement availability.
     * @see EntitlementAvailability
     */
    public final String entitlementAvailabilityAsString() {
        return entitlementAvailability;
    }

    /**
     * <p>
     * Region availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #regionAvailability} will return {@link RegionAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #regionAvailabilityAsString}.
     * </p>
     * 
     * @return Region availability.
     * @see RegionAvailability
     */
    public final RegionAvailability regionAvailability() {
        return RegionAvailability.fromValue(regionAvailability);
    }

    /**
     * <p>
     * Region availability.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #regionAvailability} will return {@link RegionAvailability#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #regionAvailabilityAsString}.
     * </p>
     * 
     * @return Region availability.
     * @see RegionAvailability
     */
    public final String regionAvailabilityAsString() {
        return regionAvailability;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelId());
        hashCode = 31 * hashCode + Objects.hashCode(agreementAvailability());
        hashCode = 31 * hashCode + Objects.hashCode(authorizationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(regionAvailabilityAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFoundationModelAvailabilityResponse)) {
            return false;
        }
        GetFoundationModelAvailabilityResponse other = (GetFoundationModelAvailabilityResponse) obj;
        return Objects.equals(modelId(), other.modelId())
                && Objects.equals(agreementAvailability(), other.agreementAvailability())
                && Objects.equals(authorizationStatusAsString(), other.authorizationStatusAsString())
                && Objects.equals(entitlementAvailabilityAsString(), other.entitlementAvailabilityAsString())
                && Objects.equals(regionAvailabilityAsString(), other.regionAvailabilityAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetFoundationModelAvailabilityResponse").add("ModelId", modelId())
                .add("AgreementAvailability", agreementAvailability()).add("AuthorizationStatus", authorizationStatusAsString())
                .add("EntitlementAvailability", entitlementAvailabilityAsString())
                .add("RegionAvailability", regionAvailabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelId":
            return Optional.ofNullable(clazz.cast(modelId()));
        case "agreementAvailability":
            return Optional.ofNullable(clazz.cast(agreementAvailability()));
        case "authorizationStatus":
            return Optional.ofNullable(clazz.cast(authorizationStatusAsString()));
        case "entitlementAvailability":
            return Optional.ofNullable(clazz.cast(entitlementAvailabilityAsString()));
        case "regionAvailability":
            return Optional.ofNullable(clazz.cast(regionAvailabilityAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("agreementAvailability", AGREEMENT_AVAILABILITY_FIELD);
        map.put("authorizationStatus", AUTHORIZATION_STATUS_FIELD);
        map.put("entitlementAvailability", ENTITLEMENT_AVAILABILITY_FIELD);
        map.put("regionAvailability", REGION_AVAILABILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFoundationModelAvailabilityResponse, T> g) {
        return obj -> g.apply((GetFoundationModelAvailabilityResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetFoundationModelAvailabilityResponse> {
        /**
         * <p>
         * The model Id of the foundation model.
         * </p>
         * 
         * @param modelId
         *        The model Id of the foundation model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelId(String modelId);

        /**
         * <p>
         * Agreement availability.
         * </p>
         * 
         * @param agreementAvailability
         *        Agreement availability.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreementAvailability(AgreementAvailability agreementAvailability);

        /**
         * <p>
         * Agreement availability.
         * </p>
         * This is a convenience method that creates an instance of the {@link AgreementAvailability.Builder} avoiding
         * the need to create one manually via {@link AgreementAvailability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AgreementAvailability.Builder#build()} is called immediately and
         * its result is passed to {@link #agreementAvailability(AgreementAvailability)}.
         * 
         * @param agreementAvailability
         *        a consumer that will call methods on {@link AgreementAvailability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agreementAvailability(AgreementAvailability)
         */
        default Builder agreementAvailability(Consumer<AgreementAvailability.Builder> agreementAvailability) {
            return agreementAvailability(AgreementAvailability.builder().applyMutation(agreementAvailability).build());
        }

        /**
         * <p>
         * Authorization status.
         * </p>
         * 
         * @param authorizationStatus
         *        Authorization status.
         * @see AuthorizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationStatus
         */
        Builder authorizationStatus(String authorizationStatus);

        /**
         * <p>
         * Authorization status.
         * </p>
         * 
         * @param authorizationStatus
         *        Authorization status.
         * @see AuthorizationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationStatus
         */
        Builder authorizationStatus(AuthorizationStatus authorizationStatus);

        /**
         * <p>
         * Entitlement availability.
         * </p>
         * 
         * @param entitlementAvailability
         *        Entitlement availability.
         * @see EntitlementAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementAvailability
         */
        Builder entitlementAvailability(String entitlementAvailability);

        /**
         * <p>
         * Entitlement availability.
         * </p>
         * 
         * @param entitlementAvailability
         *        Entitlement availability.
         * @see EntitlementAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EntitlementAvailability
         */
        Builder entitlementAvailability(EntitlementAvailability entitlementAvailability);

        /**
         * <p>
         * Region availability.
         * </p>
         * 
         * @param regionAvailability
         *        Region availability.
         * @see RegionAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionAvailability
         */
        Builder regionAvailability(String regionAvailability);

        /**
         * <p>
         * Region availability.
         * </p>
         * 
         * @param regionAvailability
         *        Region availability.
         * @see RegionAvailability
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RegionAvailability
         */
        Builder regionAvailability(RegionAvailability regionAvailability);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String modelId;

        private AgreementAvailability agreementAvailability;

        private String authorizationStatus;

        private String entitlementAvailability;

        private String regionAvailability;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFoundationModelAvailabilityResponse model) {
            super(model);
            modelId(model.modelId);
            agreementAvailability(model.agreementAvailability);
            authorizationStatus(model.authorizationStatus);
            entitlementAvailability(model.entitlementAvailability);
            regionAvailability(model.regionAvailability);
        }

        public final String getModelId() {
            return modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final AgreementAvailability.Builder getAgreementAvailability() {
            return agreementAvailability != null ? agreementAvailability.toBuilder() : null;
        }

        public final void setAgreementAvailability(AgreementAvailability.BuilderImpl agreementAvailability) {
            this.agreementAvailability = agreementAvailability != null ? agreementAvailability.build() : null;
        }

        @Override
        public final Builder agreementAvailability(AgreementAvailability agreementAvailability) {
            this.agreementAvailability = agreementAvailability;
            return this;
        }

        public final String getAuthorizationStatus() {
            return authorizationStatus;
        }

        public final void setAuthorizationStatus(String authorizationStatus) {
            this.authorizationStatus = authorizationStatus;
        }

        @Override
        public final Builder authorizationStatus(String authorizationStatus) {
            this.authorizationStatus = authorizationStatus;
            return this;
        }

        @Override
        public final Builder authorizationStatus(AuthorizationStatus authorizationStatus) {
            this.authorizationStatus(authorizationStatus == null ? null : authorizationStatus.toString());
            return this;
        }

        public final String getEntitlementAvailability() {
            return entitlementAvailability;
        }

        public final void setEntitlementAvailability(String entitlementAvailability) {
            this.entitlementAvailability = entitlementAvailability;
        }

        @Override
        public final Builder entitlementAvailability(String entitlementAvailability) {
            this.entitlementAvailability = entitlementAvailability;
            return this;
        }

        @Override
        public final Builder entitlementAvailability(EntitlementAvailability entitlementAvailability) {
            this.entitlementAvailability(entitlementAvailability == null ? null : entitlementAvailability.toString());
            return this;
        }

        public final String getRegionAvailability() {
            return regionAvailability;
        }

        public final void setRegionAvailability(String regionAvailability) {
            this.regionAvailability = regionAvailability;
        }

        @Override
        public final Builder regionAvailability(String regionAvailability) {
            this.regionAvailability = regionAvailability;
            return this;
        }

        @Override
        public final Builder regionAvailability(RegionAvailability regionAvailability) {
            this.regionAvailability(regionAvailability == null ? null : regionAvailability.toString());
            return this;
        }

        @Override
        public GetFoundationModelAvailabilityResponse build() {
            return new GetFoundationModelAvailabilityResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
