/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomatedReasoningPolicyTestCaseResponse extends BedrockResponse implements
        ToCopyableBuilder<GetAutomatedReasoningPolicyTestCaseResponse.Builder, GetAutomatedReasoningPolicyTestCaseResponse> {
    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyArn").getter(getter(GetAutomatedReasoningPolicyTestCaseResponse::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyArn").build()).build();

    private static final SdkField<AutomatedReasoningPolicyTestCase> TEST_CASE_FIELD = SdkField
            .<AutomatedReasoningPolicyTestCase> builder(MarshallingType.SDK_POJO).memberName("testCase")
            .getter(getter(GetAutomatedReasoningPolicyTestCaseResponse::testCase)).setter(setter(Builder::testCase))
            .constructor(AutomatedReasoningPolicyTestCase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCase").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_ARN_FIELD,
            TEST_CASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String policyArn;

    private final AutomatedReasoningPolicyTestCase testCase;

    private GetAutomatedReasoningPolicyTestCaseResponse(BuilderImpl builder) {
        super(builder);
        this.policyArn = builder.policyArn;
        this.testCase = builder.testCase;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the policy that contains the test.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the policy that contains the test.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * <p>
     * The test details including the content, query, expected result, and metadata.
     * </p>
     * 
     * @return The test details including the content, query, expected result, and metadata.
     */
    public final AutomatedReasoningPolicyTestCase testCase() {
        return testCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(testCase());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomatedReasoningPolicyTestCaseResponse)) {
            return false;
        }
        GetAutomatedReasoningPolicyTestCaseResponse other = (GetAutomatedReasoningPolicyTestCaseResponse) obj;
        return Objects.equals(policyArn(), other.policyArn()) && Objects.equals(testCase(), other.testCase());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomatedReasoningPolicyTestCaseResponse").add("PolicyArn", policyArn())
                .add("TestCase", testCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "policyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "testCase":
            return Optional.ofNullable(clazz.cast(testCase()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("policyArn", POLICY_ARN_FIELD);
        map.put("testCase", TEST_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomatedReasoningPolicyTestCaseResponse, T> g) {
        return obj -> g.apply((GetAutomatedReasoningPolicyTestCaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BedrockResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAutomatedReasoningPolicyTestCaseResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the policy that contains the test.
         * </p>
         * 
         * @param policyArn
         *        The Amazon Resource Name (ARN) of the policy that contains the test.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The test details including the content, query, expected result, and metadata.
         * </p>
         * 
         * @param testCase
         *        The test details including the content, query, expected result, and metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCase(AutomatedReasoningPolicyTestCase testCase);

        /**
         * <p>
         * The test details including the content, query, expected result, and metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link AutomatedReasoningPolicyTestCase.Builder}
         * avoiding the need to create one manually via {@link AutomatedReasoningPolicyTestCase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AutomatedReasoningPolicyTestCase.Builder#build()} is called
         * immediately and its result is passed to {@link #testCase(AutomatedReasoningPolicyTestCase)}.
         * 
         * @param testCase
         *        a consumer that will call methods on {@link AutomatedReasoningPolicyTestCase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCase(AutomatedReasoningPolicyTestCase)
         */
        default Builder testCase(Consumer<AutomatedReasoningPolicyTestCase.Builder> testCase) {
            return testCase(AutomatedReasoningPolicyTestCase.builder().applyMutation(testCase).build());
        }
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String policyArn;

        private AutomatedReasoningPolicyTestCase testCase;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomatedReasoningPolicyTestCaseResponse model) {
            super(model);
            policyArn(model.policyArn);
            testCase(model.testCase);
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final AutomatedReasoningPolicyTestCase.Builder getTestCase() {
            return testCase != null ? testCase.toBuilder() : null;
        }

        public final void setTestCase(AutomatedReasoningPolicyTestCase.BuilderImpl testCase) {
            this.testCase = testCase != null ? testCase.build() : null;
        }

        @Override
        public final Builder testCase(AutomatedReasoningPolicyTestCase testCase) {
            this.testCase = testCase;
            return this;
        }

        @Override
        public GetAutomatedReasoningPolicyTestCaseResponse build() {
            return new GetAutomatedReasoningPolicyTestCaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
