/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an update to a custom model deployment, including the new custom model resource ARN and current update
 * status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomModelDeploymentUpdateDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomModelDeploymentUpdateDetails.Builder, CustomModelDeploymentUpdateDetails> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(CustomModelDeploymentUpdateDetails::modelArn))
            .setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> UPDATE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateStatus").getter(getter(CustomModelDeploymentUpdateDetails::updateStatusAsString))
            .setter(setter(Builder::updateStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            UPDATE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String modelArn;

    private final String updateStatus;

    private CustomModelDeploymentUpdateDetails(BuilderImpl builder) {
        this.modelArn = builder.modelArn;
        this.updateStatus = builder.updateStatus;
    }

    /**
     * <p>
     * ARN of the new custom model being deployed as part of the update.
     * </p>
     * 
     * @return ARN of the new custom model being deployed as part of the update.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Current status of the deployment update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link CustomModelDeploymentUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return Current status of the deployment update.
     * @see CustomModelDeploymentUpdateStatus
     */
    public final CustomModelDeploymentUpdateStatus updateStatus() {
        return CustomModelDeploymentUpdateStatus.fromValue(updateStatus);
    }

    /**
     * <p>
     * Current status of the deployment update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateStatus} will
     * return {@link CustomModelDeploymentUpdateStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateStatusAsString}.
     * </p>
     * 
     * @return Current status of the deployment update.
     * @see CustomModelDeploymentUpdateStatus
     */
    public final String updateStatusAsString() {
        return updateStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(updateStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelDeploymentUpdateDetails)) {
            return false;
        }
        CustomModelDeploymentUpdateDetails other = (CustomModelDeploymentUpdateDetails) obj;
        return Objects.equals(modelArn(), other.modelArn())
                && Objects.equals(updateStatusAsString(), other.updateStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomModelDeploymentUpdateDetails").add("ModelArn", modelArn())
                .add("UpdateStatus", updateStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "updateStatus":
            return Optional.ofNullable(clazz.cast(updateStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("updateStatus", UPDATE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelDeploymentUpdateDetails, T> g) {
        return obj -> g.apply((CustomModelDeploymentUpdateDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomModelDeploymentUpdateDetails> {
        /**
         * <p>
         * ARN of the new custom model being deployed as part of the update.
         * </p>
         * 
         * @param modelArn
         *        ARN of the new custom model being deployed as part of the update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Current status of the deployment update.
         * </p>
         * 
         * @param updateStatus
         *        Current status of the deployment update.
         * @see CustomModelDeploymentUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentUpdateStatus
         */
        Builder updateStatus(String updateStatus);

        /**
         * <p>
         * Current status of the deployment update.
         * </p>
         * 
         * @param updateStatus
         *        Current status of the deployment update.
         * @see CustomModelDeploymentUpdateStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomModelDeploymentUpdateStatus
         */
        Builder updateStatus(CustomModelDeploymentUpdateStatus updateStatus);
    }

    static final class BuilderImpl implements Builder {
        private String modelArn;

        private String updateStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelDeploymentUpdateDetails model) {
            modelArn(model.modelArn);
            updateStatus(model.updateStatus);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getUpdateStatus() {
            return updateStatus;
        }

        public final void setUpdateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
        }

        @Override
        public final Builder updateStatus(String updateStatus) {
            this.updateStatus = updateStatus;
            return this;
        }

        @Override
        public final Builder updateStatus(CustomModelDeploymentUpdateStatus updateStatus) {
            this.updateStatus(updateStatus == null ? null : updateStatus.toString());
            return this;
        }

        @Override
        public CustomModelDeploymentUpdateDetails build() {
            return new CustomModelDeploymentUpdateDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
